<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use app\models\User;
 ?>
<?php $model = new User; ?>
	<form method='post' data-reloadtables='true' data-close-modal-on-success='true' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::toRoute('users/create') ?>'>
	<div class="row">
		<div class="form-group col-md-6">
			<label>Nombre de Usuario</label>
			<?= Html::activeInput('text',$model,'username',['class'=>'form-control input-sm required']); ?>
		</div>
		<div class="form-group col-md-6">
			<label>Rol de usuario</label>
			<?= Html::activeDropDownList($model,'role',User::$roleOptions,['class'=>'form-control input-sm required']); ?>
		</div>
	</div>
	<div class="row">
		<div class="form-group col-md-6">
			<label>Nombres</label>
			<?= Html::activeInput('text',$model,'firstName',['class'=>'form-control input-sm required']); ?>
		</div>
		<div class="form-group col-md-6">
			<label>Apellidos</label>
			<?= Html::activeInput('text',$model,'lastName',['class'=>'form-control input-sm required']); ?>
		</div>
	</div>
	<div class="row">
		<div class="form-group col-md-6">
			<label>Correo Electronico</label>
			<?= Html::activeInput('text',$model,'email',['class'=>'form-control input-sm required']); ?>
		</div>		
		<div class="form-group col-md-6">
			<label>Estatus</label>
			<?= Html::activeDropDownList($model,'status',$model->getStatusArray(),['class'=>'form-control input-sm required']); ?>
		</div>		
	</div>
	<div class="form-group">
		<label>Contraseña</label>
		<?= Html::activeInput('password',$model,'password_hash',['class'=>'form-control input-sm required']); ?>
	</div>
	<div class="form-group">
		<label>Repetir Contraseña</label>
		<?= Html::activeInput('password',$model,'comparePassword',['class'=>'form-control input-sm required']); ?>
	</div>
	<div class="form-group">
		<button type='submit' class='btn btn-primary'>Guardar</button>
	</div>
</form>