<?php 
	use yii\helpers\Html;
	use yii\helpers\Url;
?>
<div class="container">
	
<h1>Papeleta de vacaciones</h1>
<div class="row">
	<div class="col-xs-3 form-group">
		<label>Empresa</label>
		<select 
			class="load-content form-control input-sm"
			data-url='<?= Url::to(['requests/company-employees']) ?>'
			data-container="#employees"
		>
			<option value="">Seleccionar</option>
			<?php foreach (Yii::$app->user->identity->companies as $comp): ?>
					<option value="<?= $comp->id ?>"><?= $comp->name ?></option>
			<?php endforeach ?>
		</select>	
	</div>	
</div>
<form method='post' data-reset-on-success='true' class='ajaxSubmit validateForm' action='<?= Url::to(['requests/vacations-create']) ?>'>
<h3 class="box-form-title">Datos del empleado</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-4">
			<label>Empleado:</label>
			<select
				id='employees'
				name='VacationRequest[idEmployee]' 
				class="form-control input-sm requestEmployee"
				data-info-url="<?= Url::to(['requests/employee-data']) ?>"
				>
				<option value="">Seleccionar</option>
			</select>
		</div>
		<div class="form-group col-xs-3">
			<label>Puesto:</label>
			<input type="text" name="jobName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Departamento:</label>
			<input type="text" name="departmentName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-3">
			<label>Fecha de solicitud:</label>
			<input type="text" value="<?= date('d/m/Y') ?>" class="form-control input-sm" value='' disabled>
		</div>
	</div>
</div>
<h3 class="box-form-title">Datos de periodo vacacional</h3>
<div class="box-form">
	<label>Periodo al que corresponde:</label>
	<div class="row">
		<div class="form-group col-xs-1">
			<label>De:</label>
        	<?= Html::activeInput('text',$model,'periodStartYear',['class'=>'form-control input-sm number required']); ?>
		</div>
		<div class="form-group col-xs-1">
			<label>a:</label>
        	<?= Html::activeInput('text',$model,'periodEndYear',['class'=>'form-control input-sm number required']); ?>
		</div>
		<div class="form-group col-xs-2">
			<label>Antigüedad laboral:</label>
			<input type="text" name="entryYear" class="form-control input-sm required" disabled>
		</div>
		<div class="form-group col-xs-3" style="width:200px">
			<label>Días que corresponden:</label>
			<div class="row">
				<div class="col-xs-6">
	        		<?= Html::activeInput('text',$model,'totalDays',['class'=>'form-control input-sm number required']); ?>
				</div>				
			</div>
		</div>
		<div class="form-group col-xs-2">
			<label>Días disfrutados:</label>
			<div class="row">
				<div class="col-xs-6">
        			<?= Html::activeInput('text',$model,'usedDays',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
		<div class="form-group col-xs-2">
			<label>Días disponibles:</label>
			<div class="row">
				<div class="col-xs-6">
        			<?= Html::activeInput('text',$model,'availableDays',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<h3 class="box-form-title">Solicitud de días de disfrute</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-2">
			<label>Días a disfrutar:</label>
			<div class="row">
				<div class="col-xs-6">
	        		<?= Html::activeInput('text',$model,'daysToUse',['class'=>'form-control input-sm number daysToUse required']); ?>
				</div>
				<div class="col-xs-1">
					<i id='loadBreaks' class="fa fa-refresh fa-spin" style="display: none;"></i>
				</div>
			</div>
		</div>
		<div class="form-group col-xs-2">
			<label>Fecha de inicio:</label>
			<input type="text" name="VacationRequest[startDate]" class="form-control input-sm required calendarField startDate" >
		</div>
		<div class="form-group col-xs-2">
			<label>Descansos obligatorios:</label>
			<input type="text" name="breakDays" class="form-control input-sm breakDays"  disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Fecha termino:</label>
			<input type="text" name="endDate" class="form-control input-sm required calendarField endDate" disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Inicio a laborar:</label>
			<input type="text" name="workDate" class="form-control input-sm required calendarField workDate" disabled>
		</div>
	</div>
</div>
<h3 class="box-form-title">Observaciones</h3>
<div class="box-form">
	<div class="row">
		<div class="col-xs-6 form-group">
	    	<?= Html::activeTextarea($model,'notes',['class'=>'form-control input-sm']); ?>
		</div>	
		<div class="col-xs-6 form-group">
			<button type='submit' class="btn btn-block btn-primary">Guardar</button>
		</div>	
	</div>
</div>
</form>
<?php 
	$this->registerJsFile('@web/js/requests/vacations.js',['depends'=>[\app\assets\AppAsset::className()]]);
?>
</div>