<?php 
	use yii\helpers\Html;
	use yii\helpers\Url;
?>
<div class="container">
	
<h1>Papeleta de finiquitos</h1>

<div class="row">
	<div class="col-xs-3 form-group">
		<label>Empresa</label>
		<select 
			class="load-content form-control input-sm"
			data-url='<?= Url::to(['requests/company-employees']) ?>'
			data-container="#employees"
		>
			<option value="">Seleccionar</option>
			<?php foreach (Yii::$app->user->identity->companies as $comp): ?>
					<option value="<?= $comp->id ?>"><?= $comp->name ?></option>
			<?php endforeach ?>
		</select>	
	</div>	
</div>
<form method='post' data-reset-on-success='true' class='ajaxSubmit validateForm' action='<?= Url::to(['requests/settlement-create']) ?>'>
<h3 class="box-form-title">Datos del empleado</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-3">
			<label>Empleado:</label>
			<select
				id='employees'
				name='SettlementRequest[idEmployee]' 
				class="form-control input-sm requestEmployee"
				data-info-url="<?= Url::to(['requests/employee-data']) ?>"
				>
				<option value="">Seleccionar</option>
			</select>
		</div>
		<div class="form-group col-xs-3">
			<label>Puesto:</label>
			<input type="text" name="jobName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Departamento:</label>
			<input type="text" name="departmentName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Fecha de baja:</label>
        	<?= Html::activeInput('text',$model,'fechaBaja',['class'=>'form-control input-sm calendarField required']); ?>
		</div>
		<div class="form-group col-xs-2">
			<label>Fecha de solicitud:</label>
			<input type="text" value="<?= date('d/m/Y') ?>" class="form-control input-sm" value='' disabled>
		</div>
	</div>
</div>
<h3 class="box-form-title">Datos</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-4">
			<label>Fecha de pago:</label>
        	<?= Html::activeInput('text',$model,'fechaDePago',['class'=>'form-control input-sm calendarField required']); ?>
		</div>
		<div class="form-group col-xs-3">
			<label>Hora de pago:</label>
			<div class="row">
				<div class="col-xs-4">
					<select style='padding: 5px' class="form-control input-sm" name="SettlementRequest[horaDePago]">
						<?php for($i=0;$i<=23;$i++): ?>
							<?php $aux = $i<10?'0'.$i:$i; ?>
							<option <?= $aux ?>><?= $aux ?></option>
						<?php endfor; ?>
					</select>
				</div>
				<p class="pull-left">:</p>
				<div class="col-xs-4">
					<select style='padding: 5px' class="form-control input-sm" name="SettlementRequest[minutoDePago]">
						<?php for($i=0;$i<60;$i++): ?>
							<?php $aux = $i<10?'0'.$i:$i; ?>
							<option <?= $aux ?>><?= $aux ?></option>
						<?php endfor; ?>
					</select>
				</div>
				<p class="pull-left">hrs</p>
			</div>
		</div>			
		<div class="form-group col-xs-2">
			<label>Ubicación de pago</label>
			<select name='SettlementRequest[lugarDePago]' class="form-control input-sm">
				<option value="Oficina SAAV">Oficina SAAV</option>
				<option value="Oficina Cliente">Oficina Cliente</option>
				<option value="Oficina Conciliacion">Oficina Conciliación</option>
			</select>
		</div>
		<div class="form-group col-xs-2">
			<label>Baja IMSS</label>
			<select name='SettlementRequest[bajaImss]' class="form-control input-sm">
				<option value="1">SI</option>
				<option value="0">NO</option>
			</select>
		</div>
	</div>
	<div class="row">
		<div class="col-xs-2 form-group">
			<label>Días de gratificación</label>
			<div class="row">
				<div class="col-xs-6">
        			<?= Html::activeInput('text',$model,'diasGratificacion',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
		<div class="col-xs-2 form-group">
			<label>Vacaciones gozadas</label>
			<div class="row">
				<div class="col-xs-6">
        			<?= Html::activeInput('text',$model,'vacacionesGozadas',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
		<div class="col-xs-3 form-group">
			<label>Prima de vacaciones pagadas</label>
			<div class="row">
				<div class="col-xs-4">
        			<?= Html::activeInput('text',$model,'primaVacacionesPagadas',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-xs-6">
			<table class="table table-condensed table-bordered">
				<thead>
					<tr>
						<th colspan="2" class="text-center">Percepciones</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>Días devengados</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[diasDevengados]"></td>
					</tr>
					<tr>
						<td>Horas extra</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[horasExtra]"></td>
					</tr>
					<tr>
						<td>Día festivo</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[diaFestivo]"></td>
					</tr>
					<tr>
						<td>Prima dominical</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[primaDominical]"></td>
					</tr>
					<tr>
						<td>Compensación</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[compensacion]"></td>
					</tr>
					<tr>
						<td>Bono</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[bono]"></td>
					</tr>
					<tr>
						<td>Otras percepciones</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[otrasPercepciones]"></td>
					</tr>
				</tbody>
			</table>
		</div>
		<div class="col-xs-6">
			<table class="table table-condensed table-bordered">
				<thead>
					<tr>
						<th colspan="2" class="text-center">Deducciones</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>Ausentismos</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[ausentismos]"></td>
					</tr>
					<tr>
						<td>Sueldo pagado de mas</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[sueldoPagadoDeMas]"></td>
					</tr>
					<tr>
						<td>CxC</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[cxc]"></td>
					</tr>
					<tr>
						<td>Préstamo</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[prestamo]"></td>
					</tr>
					<tr>
						<td>Otros descuentos</td>
						<td><input type="text" class='form-control input-sm numberField2' value='0' name="SettlementRequest[otrosDescuentos]"></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="row">
		<div class="form-group col-xs-6">
			<label>Observaciones</label>
			<textarea name="SettlementRequest[observaciones]" class="form-control input-sm"></textarea>
		</div>
		<div class="col-xs-6 form-group">
		<label>.</label>
			<button type='submit' class="btn btn-block btn-primary">Guardar</button>
		</div>	
	</div>
</div>
</form>
<?php 
	$this->registerJsFile('@web/js/requests/vacations.js',['depends'=>[\app\assets\AppAsset::className()]]);
?>
</div>