<?php 
	use yii\helpers\Html;
	use yii\helpers\Url;
	use app\models\NoticeRequest;
?>
<div class="container">
	
<h1>Papeleta de avisos</h1>
<form method='post' data-reset-on-success='true' class='ajaxSubmit validateForm' action='<?= Url::to(['requests/notices-create']) ?>'>
<div class="row">
	<div class="col-xs-3 form-group">
		<label>Empresa</label>
		<select 
			class="load-content form-control input-sm"
			data-url='<?= Url::to(['requests/company-employees']) ?>'
			data-container="#employees"
		>
			<option value="">Seleccionar</option>
			<?php foreach (Yii::$app->user->identity->companies as $comp): ?>
					<option value="<?= $comp->id ?>"><?= $comp->name ?></option>
			<?php endforeach ?>
		</select>	
	</div>	
	<div class="col-xs-3 form-group">
		<label>Tipo de aviso</label>
		<select class="form-control input-sm select-container" name="NoticeRequest[noticeType]">
			<option value="">Seleccionar</option>
		<?php foreach (NoticeRequest::$typeOptions as $key => $value): ?>
			<option value="<?= $key ?>" data-container='.noticeType<?= $key ?>'><?= $value ?></option>
		<?php endforeach ?>
		</select>
	</div>
</div>
<h3 class="box-form-title">Datos del empleado</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-4">
			<label>Empleado:</label>
			<select
				id='employees'
				name='NoticeRequest[idEmployee]' 
				class="form-control input-sm requestEmployee"
				data-info-url="<?= Url::to(['requests/employee-data']) ?>"
				>
				<option value="">Seleccionar</option>
			</select>
		</div>
		<div class="form-group col-xs-3">
			<label>Puesto:</label>
			<input type="text" name="jobName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Departamento:</label>
			<input type="text" name="departmentName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-3">
			<label>Fecha de solicitud:</label>
			<input type="text" value="<?= date('d/m/Y') ?>" class="form-control input-sm" value='' disabled>
		</div>
	</div>
</div>
<h3 class="box-form-title">Días y horas a laborar</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-2 noticeType<?= NoticeRequest::TYPE_DT ?> noticeType<?= NoticeRequest::TYPE_FL ?>">
			<label>Días a laborar:</label>
			<div class="row">
				<div class="col-xs-6">
				<?php 
					$model->workDays = 0;
					$model->extraHours = 0;
					$model->doubleWorkDay = 0;
				 ?>
	        		<?= Html::activeInput('text',$model,'workDays',['class'=>'form-control input-sm number required']); ?>
				</div>				
			</div>
		</div>
		<div class="form-group col-xs-2 noticeType<?= NoticeRequest::TYPE_HE ?>">
			<label>Horas extra:</label>
			<div class="row">
				<div class="col-xs-6">
        			<?= Html::activeInput('text',$model,'extraHours',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
		<div class="form-group col-xs-2 noticeType<?= NoticeRequest::TYPE_TD ?>">
			<label>Doble turno:</label>
			<div class="row">
				<div class="col-xs-6">
        			<?= Html::activeInput('text',$model,'doubleWorkDay',['class'=>'form-control input-sm number required']); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="form-group col-xs-3">
			<label>Fecha de evento:</label>
			<?= Html::activeInput('text',$model,'eventDate',['class'=>'form-control input-sm calendarField required']); ?>
		</div>
	</div>
</div>
<h3 class="box-form-title">Observaciones</h3>
<div class="box-form">
	<div class="row">
		<div class="col-xs-6 form-group">
	    	<?= Html::activeTextarea($model,'notes',['class'=>'form-control input-sm']); ?>
		</div>	
		<div class="col-xs-6 form-group">
			<button type='submit' class="btn btn-block btn-primary">Guardar</button>
		</div>	
	</div>
</div>
</form>
<?php 
	$this->registerJsFile('@web/js/requests/vacations.js',['depends'=>[\app\assets\AppAsset::className()]]);
?>
</div>