<?php 

use app\models\WorkingPeriod;
use app\models\Department;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
 ?>
<form id='incidentsCalendarForm' class='load-content' data-container='#incidentsCalendar' method='post' action='<?= Url::to(['payroll-concepts/calendar']) ?>'>
<div class="row">
	<div class="col-md-4">
		<div class="form-group">
			<label>Empresa</label>
			<select 
			id='company' 
			data-info='<?= Url::to(['incidents/company-options']) ?>' 
			name='company' 
			class='form-control input-sm load-info'>
				<option value=''>Seleccionar</option>
				<?php foreach (Yii::$app->user->identity->companies as $c): ?>
					<option value='<?= $c->id ?>'><?= $c->name ?></option>
				<?php endforeach ?>
			</select>
		</div>
		<div class="form-group">
			<label>Periodo</label>
			<select name='period' class='form-control input-sm'></select>
		</div>
		<div class="form-group">
			<label>Departamento</label>
			<select name='department' class='form-control input-sm'></select>
		</div>
	</div>
</div>
<div class="form-group">
	<button type='submit' class='btn btn-primary'>Consultar</button>
	<a id='exportCalendar' href='<?= Url::to(['payroll-concepts/export']) ?>' class='btn btn-warning'>Exportar <i class='fa fa-file-pdf-o'></i></a>
</div>
</form>
<hr>
<div id='incidentsCalendar'></div>