<?php
use app\components\PayrollConceptsComponent;
use app\models\Period;
$totalConcepts = count(PayrollConceptsComponent::$concepts);
?>
<style type="text/css">
* {font-size: 8pt}
table.incidents{text-align: center;font-size: 7pt}
table.incidents td,table.incidents th{width: <?= 52/$totalConcepts ?>%}
table.incidents .longs{width: 20%;text-align: left;}
table.incidents .short{width: 8%;text-align: left;}
</style>
<table style="width:100%">
<tr>
	<td>
		<p>Empresa: <strong><?= $period->company->name ?></strong></p>
		<p>Periodo: <strong><?= $period->getDateField('startDate')->format('d/m/Y') ?> - <?= $period->getDateField('endDate')->format('d/m/Y') ?></strong></p>
		<p>Estado: <strong><?= $period->getEnumField('status'); ?></strong></p>
		<?php if ($period->status!=Period::STATUS_OPEN): ?>
			<p>Enviado a revisión por: <strong><?= $period->userClosure->fullName ?></strong></p>
			<p>Fecha y Hora de envío: <strong><?= $period->getFullDateField('closureDate',true) ?></strong></p>
			<p>Cierre al: <strong><?= $period->getDateField('incidentsLastDate')->format('d/m/Y') ?></strong></p>	
		<?php endif ?>
		<?php if ($period->status==Period::STATUS_CLOSE && Yii::$app->user->identity->isAdmin()): ?>
			<p>Periodo aprobado y cerrado por: <strong><?= $period->userAproval->fullName ?></strong></p>	
		<?php endif ?>
	</td>
</tr>
</table>
<br>
<br>
<table class="incidents" border="1" cellpadding="5">
		<tr>
			<th rowspan="2" class="short">ID</th>
			<th rowspan="2" class="longs">Empleado</th>
			<th rowspan="2" class="longs">Puesto</th>
			<th style="width:<?= 52/2 ?>%" colspan="<?= count(PayrollConceptsComponent::$perceptions) ?>">Percepciones</th>
			<th style="width:<?= 52/2 ?>%" colspan="<?= count(PayrollConceptsComponent::$deductions) ?>">Deducciones</th>
		</tr>
		<tr>
			<?php foreach (PayrollConceptsComponent::$concepts as $p): ?>
				<th><?= $p ?></th>
			<?php endforeach ?>
		</tr>
		<?php foreach ($employees as $e): ?>
			<?php $employeeConcepts = PayrollConceptsComponent::getEmployeeConcepts($e->id,$period->id); ?>
			<tr>
				<td class="short"><?= $e->refId ?></td>
				<td class="longs"><?= $e->fullNameInverse ?></td>
				<td class="longs"><?= $e->job->name ?></td>
				<?php foreach (PayrollConceptsComponent::$concepts as $key => $p): ?>
					<td>
						<?= $employeeConcepts?$employeeConcepts->$key:0 ?>
					</td>
				<?php endforeach ?>
			</tr>
		<?php endforeach ?>
</table>
<br>
<br>
<h3>Firmas de autorización</h3>
<table style="text-align:center">
	<tr>
		<td></td>
		<td>
			__________________________ <br><br>
			Visto Bueno	
		</td>
		<td>
			__________________________ <br><br>
			Autorizo	
		</td>
		<td></td>
	</tr>
</table>
