<?php
use app\assets\AppAsset;
use yii\helpers\Html;
use yii\helpers\Url;
use app\models\User;
/* @var $this \yii\web\View */
/* @var $content string */
AppAsset::register($this);
$this->title = "SIGENI | Grupo Lamhi";
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic' rel='stylesheet' type='text/css'>
    <link href="/images/favicon.ico" rel="shortcut icon">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
    <?php $this->beginBody() ?>
      <div id='logo-box'>
        <a href="http://lamhi.com.mx/">
          <img id='header-logo' src="/images/logo.png" style="max-height: 100%">
          <span></span>
        </a>        
        <div class="bar"></div>
      </div>
      <nav class="navbar navbar-default">
        <div class="container-fluid">
          <div class="navbar-header">
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
              <i class='fa fa-bars fa-2x' style='color:white'></i>
            </button>
          </div>
            <div class="collapse navbar-collapse" id='bs-example-navbar-collapse-1'>
              <ul class="nav navbar-nav navbar-left">
                <!-- <?php 
                  $controllerId = Yii::$app->controller->id; 
                  $userRole = Yii::$app->user->identity->role; 
                ?>
                <?php if ($userRole==User::ROLE_EXECUTIVE): ?>
                  <li class='<?= $controllerId=='employees'?'active':'' ?>'><a href="<?= Url::toRoute('/employees') ?>"><i class='fa fa-user'></i> Empleados</a></li>
                  <li class='<?= $controllerId=='contracts'?'active':'' ?>'><a href="<?= Url::toRoute('/contracts') ?>"><i class='fa fa-user'></i> Contratos</a></li>
                <?php elseif($userRole==User::ROLE_MANAGER): ?>
                  <li class='<?= $controllerId=='employees'?'active':'' ?>'><a href="<?= Url::toRoute('/employees') ?>"><i class='fa fa-user'></i> Empleados</a></li>
                  <li class='<?= $controllerId=='contracts'?'active':'' ?>'><a href="<?= Url::toRoute('/contracts') ?>"><i class='fa fa-user'></i> Contratos</a></li>
                  <li class='<?= $controllerId=='settings'?'active':'' ?>'><a href="<?= Url::toRoute('/settings') ?>"><i class='fa fa-gear'></i> Configuraciones</a></li>                 
                <?php elseif($userRole==User::ROLE_HUMANRESOURCES): ?>
                  <li class='<?= $controllerId=='contracts'?'active':'' ?>'><a href="<?= Url::toRoute('/contracts') ?>"><i class='fa fa-user'></i> Contratos</a></li>
                <?php endif ?>
                <li class='<?= $controllerId=='incidents'?'active':'' ?>'><a href="<?= Url::toRoute('/incidents') ?>"><i class='fa fa-calendar'></i> Carga de Incidencias</a></li>
                <?php if ($userRole!=User::ROLE_DEPARTMENTMANAGER): ?>
                <li class='dropdown <?= $controllerId=='requests'?'active':'' ?>'>
                  <a href="#" class="dropdown-toggle" data-toggle='dropdown'>
                    <i class='fa fa-file-text-o'></i> Movimiento de personal <span class="caret"></span>
                  </a>
                  <ul class='dropdown-menu'>
                    <li><a href="<?= Url::to(['requests/']) ?>">Lista</a></li>
                    <li role="separator" class="divider"></li>
                    <li><a href="<?= Url::to(['requests/vacations']) ?>">Vacaciones</a></li>
                    <li><a href="<?= Url::to(['requests/settlement']) ?>">Finiquitos</a></li>
                    <li><a href="<?= Url::to(['requests/permissions']) ?>">Permisos</a></li>
                    <li><a href="<?= Url::to(['requests/notices']) ?>">Avisos</a></li>
                  </ul>
                </li>
                <li class='<?= $controllerId=='reports'?'active':'' ?>'><a href="<?= Url::toRoute('/reports') ?>"><i class='fa fa-money'></i> Reportes</a></li>
                <?php endif ?> -->
                <li class='<?= $controllerId=='employees'?'active':'' ?>'><a href="<?= Url::toRoute('/employees') ?>"> Empleados</a></li>
                <li class='<?= $controllerId=='incidents'?'active':'' ?>'><a href="<?= Url::toRoute('incidents/menu') ?>"> Incidencias</a></li>
                <!-- <li class='<?= $controllerId=='employees'?'active':'' ?>'><a href="<?= Url::toRoute('/employees') ?>"> Nominas</a></li> -->
                <li class='<?= $controllerId=='contracts'?'active':'' ?>'><a href="<?= Url::toRoute('contracts/menu') ?>"> RRHH</a></li>
                <!-- <li class='<?= $controllerId=='employees'?'active':'' ?>'><a href="<?= Url::toRoute('/employees') ?>"> Presupuesto</a></li> -->
                <li class='<?= $controllerId=='settings'?'active':'' ?>'><a href="<?= Url::toRoute('/settings') ?>"> Parámetros</a></li>

              </ul>
              <ul class="nav navbar-nav navbar-right">
                <li class="dropdown pull-right">
                  <a href="#" class="dropdown-toggle text-uppercase" data-toggle="dropdown" role="button" ><i class='fa fa-user'></i> <?= Yii::$app->user->identity->username ?> <span class="caret"></span></a>
                  <ul class="dropdown-menu">
                    <li><a href="<?= Url::to(['site/logout']) ?>">Salir</a></li>
                  </ul>
                </li>
              </ul>
            </div>
        </div>
      </nav>
      <!-- NAV -->
      <main>
        <?= $content ?>
      </main>
      <footer>
        <p>Cancún Q. Roo Smza 32 Mza 01 Lote 01 Local 18 Plaza Hollywood C.P. 77500</p>
        <ul class="media_icon">
            <li><a href="#"><i class="fa fa-facebook"></i></a></li>
            <li><a href="#"><i class="fa fa-twitter"></i></a></li>
            <li><a href="#"><i class="fa fa-google-plus"></i></a></li>
            <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
        </ul>
      </footer>
      <!-- warning modal -->
      <div id='warning-modal' class="modal fade" tabindex="-1" role="dialog">
          <div class="modal-body">
              <h5>¿Esta seguro que desea continuar?</h5>       
              <p class='extra-message'></p>       
          </div>
          <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
               <a href='#' class="btn btn-primary action-button" >Continuar</a>
          </div>                                        
      </div>
    <?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
