<?php 
use app\models\WorkingPeriod;
use app\models\Department;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
 ?>
 <div class="container">
<form  id='incidentsCalendarForm' method='post'>
<div class="row">
	<div class="col-md-4">
		<div class="form-group">
			<label>Empresa</label>
			<select 
			id='company' 
			data-info='<?= Url::to(['incidents/company-options']) ?>' 
			name='company' 
			class='form-control input-sm load-info'>
				<option value=''>Seleccionar</option>
				<?php foreach (Yii::$app->user->identity->companies as $c): ?>
					<option value='<?= $c->id ?>'><?= $c->name ?></option>
				<?php endforeach ?>
			</select>
		</div>
		<div class="form-group">
			<label>Periodo</label>
			<select name='period' class='form-control input-sm' ></select>
		</div>
		<div class="form-group">
			<label>Departamento</label>
			<select name='department' class='form-control input-sm'></select>
		</div>
		<div class="form-group">
			<label>Calendario</label>
			<select name='calendar' class='form-control input-sm'>
				<option value='incidents'>Incidencias</option>
				<?php if (Yii::$app->user->identity->role!=User::ROLE_DEPARTMENTMANAGER): ?>
					<option value='payroll-concepts'>Conceptos</option>
				<?php endif ?>
			</select>
		</div>
	</div>
</div>
<div class="form-group">
	<button type='button' class='collapse btn-consult btn btn-primary' >Consultar</button>
</div>
</form>
<hr>
<div id='incidentsCalendar'></div>
 </div>