<?php
use yii\helpers\Url;
use app\components\IncidentsComponent;
use app\components\IncidentCategoriesComponent;
use app\components\HolidaysComponent;
use app\models\IncidentCategory;
use app\models\User;
use app\models\Period;
use app\models\Employee;

$incidentCategories = IncidentCategory::find()->all();

$auxWeek = ['D','L','M','M','J','V','S'];
$theadWeek = "";
$theadDays = "";
$auxStart = $period->getDateField('startDate');
$auxEnd = $period->getDateField('endDate');
$holidays = HolidaysComponent::getDays($period->startDate,$period->endDate);
while($auxStart<=$auxEnd){
	$tdAttrs = "";
	if(isset($holidays[$auxStart->format('Y-m-d')])) $tdAttrs="class='warning' title='".$holidays[$auxStart->format('Y-m-d')]."'";
	$theadWeek.="<td $tdAttrs>".$auxWeek[$auxStart->format('w')]."</td>";
	$theadDays.="<td $tdAttrs>".$auxStart->format('d')."</td>";
	$auxStart->modify('+1 day');
}
?>
<h3><?= $period->company->name ?></h3>
<div class="export-buttons">
	<a target='_blank' href='<?= Url::to(['incidents/export','period'=>$period->id,'department'=>$idDepartment]) ?>' class='btn btn-warning'>Exportar <i class='fa fa-file-pdf-o'></i></a>	
	<?php if (Yii::$app->user->identity->isAdmin()): ?>
		<a href='<?= Url::to(['reports/exportimp','period'=>$period->id]) ?>' class='btn btn-warning' >Exportar IMP <i class='fa fa-file-excel-o'></i></a>
	<?php endif ?>
</div>

<p>Periodo: <strong><?= $period->getDateField('startDate')->format('d/m/Y') ?> - <?= $period->getDateField('endDate')->format('d/m/Y') ?></strong></p>
<!-- <p>Estado: <strong><?= $period->getEnumField('status'); ?></strong></p> -->
<?php if ($period->status!=Period::STATUS_OPEN): ?>
	<p>Periodo aprobado por: <strong><?= $period->userClosure->fullName ?></strong></p>
	<p>Fecha y Hora de envío: <strong><?= $period->getFullDateField('closureDate',true) ?></strong></p>
	<p>Cierre al: <strong><?= $period->getDateField('incidentsLastDate','d/m/Y') ?></strong></p>	
<?php endif ?>
<?php if ($period->status==Period::STATUS_CLOSE && Yii::$app->user->identity->isAdmin()): ?>
	<p>Cerrado por: <strong><?= $period->userAproval->fullName ?></strong></p>	
<?php endif ?>

<hr>
<form class='ajaxSubmit' method='post' action='<?= Url::to(['incidents/save-period','id'=>$period->id]) ?>'>
<div class="table-responsive">
<table data-ordering='false' data-searching='false' class='hasDataTable incidentsTable table table-hover  text-center table-bordered table-condensed'>
	<thead>
		<tr class='info'>
			<td></td>
			<td></td>
			<td></td>
			<?= $theadWeek ?>
		</tr>
		<tr class='info'>
			<td class='text-left'>ID</td>
			<td class='text-left'>Empleado</td>
			<td class='text-left'>Puesto</td>
			<?= $theadDays ?>
		</tr>
	</thead>
	<?php $isAdmin = Yii::$app->user->identity->isAdmin() ?>
	<tbody>
		<?php foreach ($employees as $e): ?>
			<?php $prevIncidents = IncidentsComponent::getEmployeeIncidents($e->id,$period); ?>
			<tr>
				<td class='text-left'><?= $e->refId ?></td>
				<td class='text-left'><?= $e->fullNameInverse ?></td>
				<td class='text-left'><?= $e->job->name ?></td>
				<?php 
					$auxStart = $period->getDateField('startDate'); 
					$inactiveDate = $e->getInactiveDate($period->startDate,$period->endDate);
					$readmissionDate = $e->getReadmissionDate($period->startDate,$period->endDate);
					$creationDate = $e->firstChange->applyDate;
				?>
				<?php while($auxStart<=$auxEnd): ?>
						<?php
							$isHoliday = isset($holidays[$auxStart->format('Y-m-d')]);
							$dateStr = $auxStart->format('Y-m-d');
							$prevIncident = $prevIncidents[$dateStr];
							if($isAdmin){
								$disabled = $period->closeAllDays || ($period->status==Period::STATUS_CLOSE && $dateStr<=$period->incidentsLastDate);
							}else{
								$disabled = $period->closeAllDays || ($period->status!=Period::STATUS_OPEN && $dateStr<=$period->incidentsLastDate);
							}
							// se desactivan casillas según las altas,bajas y reingresos
							if($dateStr < $creationDate) $disabled = true;
							else if($readmissionDate!='0000-00-00' && $inactiveDate!='0000-00-00'){
								if ($dateStr >= $inactiveDate && $dateStr < $readmissionDate) $disabled = true;
							}
							else if($readmissionDate!='0000-00-00' && $dateStr < $readmissionDate) $disabled = true;
							else if($inactiveDate!='0000-00-00' && $dateStr >= $inactiveDate) $disabled = true;

							$disabled = $prevIncident->idRequest>0?true:$disabled;
						?>
					<td class="<?= $disabled?'danger':'' ?>">
						<select 
							<?= $disabled?'disabled':'' ?> 
							name='data[<?= $e->id ?>][<?= $dateStr ?>]' 
							class='incident-select '
							<?= $prevIncident->idRequest>0?"title='".$prevIncident->getEnumField('requestType')."'":'' ?>
						>
							<?php foreach ($incidentCategories as $c): ?>
								<?php 
									$showCat = true;
									if($prevIncident->idIncidentCategory!=$c->id){
										if($c->usedByRequest || ($isHoliday && !in_array($c->id, IncidentCategoriesComponent::getHolidayOptions())) || ($c->tag=='DF' && !$isHoliday)) $showCat = false;
									}
									$optionSelected = $prevIncident->idIncidentCategory==$c->id; 
									// $showCat = !$optionDisabled && (!$isHoliday || ($isHoliday && in_array($c->id, IncidentCategoriesComponent::getHolidayOptions())));
								 ?>
								 <?php if ($showCat): ?>
									<option
										<?= $optionSelected?'selected':'' ?> 
										value='<?= $c->id ?>'
										>
										<?= $c->tag ?>
									</option>								 	
								 <?php endif ?>
							<?php endforeach ?>
						</select>
					</td>
				<?php $auxStart->modify('+1 day') ?>
				<?php endwhile; ?>
			</tr>
		<?php endforeach ?>
	</tbody>
</table>
</div>
<div class="text-right">
	<button type='submit' class='btn btn-primary' >Guardar Cambios</button>
	<?php if ($period->status==Period::STATUS_OPEN): ?>
		<?php if (Yii::$app->user->identity->role==User::ROLE_HUMANRESOURCES): ?>
			<a href='#confirmSendReview' data-toggle='modal' class='btn btn-warning' >Enviar a revisión</a>
		<?php endif ?>
	<?php elseif($period->status==Period::STATUS_REVIEW): ?>
		<?php if (Yii::$app->user->identity->isAdmin()): ?>
			<a href='<?= Url::to(['incidents/aproval','id'=>$period->id]) ?>' class='ajaxLink btn btn-warning show-warning' data-warning-message="No se podrán modificar las incidencias despues de esta acción.">Aprobar Cierre</a>
		<?php endif ?>
	<?php endif ?>
</div>
</form>
<h3>Tipos de incidencias</h3>
<div class="row">
	<?php foreach ($incidentCategories as $ic): ?>
		<div class="col-md-3">
			<strong><?= $ic->tag ?></strong>: <?= $ic->name ?>
			<?php if ($ic->usedByRequest): ?>
				<i data-toggle="tooltip" data-placement="top" title="Requiere papeleta" class="fa fa-exclamation-circle"></i>
			<?php endif ?>
		</div>
	<?php endforeach ?>	
</div>
<div id='confirmSendReview' class="modal">
	<div class="modal-header">
		<h3 class='modal-title'>Cierre de incidencias</h3>
	</div>
	<div class="modal-body">
		<form class='ajaxSubmit' data-close-modal-on-success='true' method='post' action='<?= Url::to(['incidents/send-review','id'=>$period->id]) ?>'>
			<div class="row">
				<div class="col-sm-6">
					<p><strong>Se cerraran todas las fechas anteriores a la fecha de cierre del actual periodo</strong></p>
				</div>
				<div class="col-sm-6 form-group">
					<label>Fecha de cierre</label>
					<input type='text' style='max-width:150px' class='form-control input-sm calendarField' value='<?= date('Y-m-d') ?>' name='closeDate'>
				</div>
			</div>
			<button type='submit' class='btn btn-primary'>Enviar a revisión</button>
		</form>
	</div>
</div>