<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Department;
use app\models\Job;
?>
<div class="row">
    <div class="form-group col-sm-4">
        <label>Departamento</label>
        <?= Html::activeDropDownList($model,'idDepartment',ArrayHelper::map(Department::find()->all(),'id','name'),['class'=>'form-control input-sm required','prompt'=>'Seleccionar']); ?>
    </div>
    <div class="form-group col-sm-4">
        <label>Puesto</label>
        <?= Html::activeDropDownList($model,'idJob',ArrayHelper::map(Job::find()->all(),'id','name'),['class'=>'form-control input-sm required','prompt'=>'Seleccionar']); ?>
    </div>
</div>
<div class="row">
    <div class="form-group col-sm-4">
        <label>Fecha ingreso a empresa</label>
        <?= Html::activeInput('text',$model,'entryDateCompany',['class'=>'form-control input-sm required calendarField']); ?>
    </div>
    <div class="form-group col-sm-4">
        <label>Fecha ingreso LAMHI</label>
        <?= Html::activeInput('text',$model,'entryDateSaav',['class'=>'form-control input-sm required calendarField']); ?>
    </div>
</div>
<div class="row">
    <div class="form-group col-sm-4">
        <label>Descansos</label><br>
        <?php $breakDays = $model->getBreakDays(); ?>
        <?php foreach (['D','L','M','M','J','V','S'] as $key=>$day): ?>
            <label>
                <?= $day ?><br>
                <input <?= in_array($key,$breakDays)?"checked='checked'":'' ?> type="checkbox" name="breakDays[]" value="<?= $key ?>">
            </label>
        <?php endforeach ?>
    </div>
</div>