<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Employee;
use app\models\Department;
use app\models\Job;
 ?>
<div class="container">
<h2 >
    Empleados
    <a  href='<?= Url::toRoute('employees/new') ?>' data-modal-width='800' class='btn btn-primary btn-sm' data-toggle='modalDinamic'>Nuevo Empleado</a>
    <a  href='<?= Url::toRoute('employees/import') ?>' data-modal-width='800' class='btn btn-primary btn-sm' data-toggle='modalDinamic'>Importar de Excel</a>
</h2>
<hr>
<?php $auxId = Yii::$app->security->generateRandomString(5) ?>
<!-- <div class='collapse' id='container<?= $auxId ?>'> -->
<form id='<?= $auxId ?>' class='filters-form' data-keyup='true' >
    <h4>Filtros</h4>
    <div class="row">
        <div class="col-md-1 form-group">
            <label>ID</label>
            <input type='text' name='col0' class='form-control input-sm'>
        </div>
        <div class="col-md-2 form-group">
            <label>Nombre</label>
            <input type='text' name='col1' class='form-control input-sm'>
        </div>
        <div class="col-md-2 form-group">
            <label>Departamento</label>
            <?= Html::dropDownList('col2','',ArrayHelper::map(Department::find()->all(),'id','name'),['class'=>'form-control input-sm','prompt'=>'Todos']) ?>
        </div>
        <div class="col-md-2 form-group">
            <label>Puesto</label>
            <?= Html::dropDownList('col3','',ArrayHelper::map(Job::find()->all(),'id','name'),['class'=>'form-control input-sm','prompt'=>'Todos']) ?>
        </div>
        <div class="col-md-1 form-group">
            <label>Estado</label>
            <?= Html::dropDownList('col4','',[1=>'VIGENTE',2=>'BAJA'],['class'=>'form-control input-sm','prompt'=>'Todos']) ?>
        </div>
        <div class="col-md-2 form-group">
            <label>Empresa</label>
            <?= Html::dropDownList('col5','',ArrayHelper::map(Yii::$app->user->identity->companies,'id','name'),['class'=>'form-control input-sm','prompt'=>'Todos']) ?>
        </div>
    </div>
</form>
<!-- </div> -->
<hr>
<table data-filters="#<?= $auxId ?>" data-ajax-url='<?= Url::toRoute('employees/listing') ?>' class='hasDataTableAjax table table-condensed table-bordered table-striped'>
    <thead>
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Departamento</th>
            <th>Puesto</th>
            <th>Estado</th>
            <th>Empresa</th>
            <th>Acciones</th>
        </tr>
    </thead>
</table>
 </div>