<?php 

use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Department;
use app\models\ContractType;
use app\components\SettingsComponent;
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    <h3 class='modal-title'>Nuevo contrato</h3>
</div>
<div class="modal-body">
    <div class="dinamic-tab">
        <ul class='nav nav-tabs'>
            <li class='active'> <a href="#" data-toggle='tab'>Nuevo contrato</a></li>
            <li> <a href="#" data-toggle='tab'>Histórico</a></li>
        </ul>
        <div class="tab-content">
            <div class='tab-pane active'>
                <form method='post' data-reloadtables='true' data-close-modal-on-success='true' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::toRoute('contracts/create') ?>'>
                    <div class="form-group">
                        <label>Empresa</label>
                        <input class='form-control input-sm' value='<?= $model->employee->company->name ?>' disabled>
                    </div>
                    <div class="form-group">
                        <label>Empleado</label>
                        <input type='text' value='<?= $model->employee->firstName.' '.$model->employee->lastName1.' '.$model->employee->lastName2 ?>' class='form-control input-sm' disabled>
                        <?= Html::activeInput('hidden',$model,'idEmployee'); ?>
                    </div>      
                    <div class="form-group">
                        <label>Tipo de contrato</label>
                        <select class='form-control input-sm required' name='Contract[idContractType]'>
                        <?php foreach (ContractType::find()->all() as $ct): ?>
                            <option value='<?= $ct->id ?>' data-testdays='<?= $ct->testDays ?>' data-need-enddate='<?= $ct->needEndDate ?>'><?= $ct->name ?></option>
                        <?php endforeach ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Departamento</label>
                        <input type='text' class='form-control input-sm' value='<?= $model->employee->department->name ?>' disabled>
                    </div>
                    <div class="form-group">
                        <label>Puesto</label>
                        <input type='text' class='form-control input-sm' value='<?= $model->employee->job->name ?>' disabled>
                    </div>      
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label>Fecha de inicio</label>
                            <?= Html::activeInput('text',$model,'startDate',['class'=>'form-control input-sm required calendarField']); ?>
                        </div>    
                        <div class="form-group col-md-6">
                            <label>Fecha fin</label>
                            <?= Html::activeInput('text',$model,'endDate',['class'=>'form-control input-sm  calendarField','readonly'=>'readonly']); ?>
                        </div>    
                    </div>
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label>Ingreso Empresa</label>
                            <?= Html::activeInput('text',$model,'entryDateCompany',['class'=>'form-control input-sm required','readonly'=>'readonly']); ?>
                        </div>    
                        <div class="form-group col-md-4">
                            <label>Ingreso IMSS</label>
                            <?= Html::activeInput('text',$model,'entryDateSaav',['class'=>'form-control input-sm required','readonly'=>'readonly']); ?>
                        </div>    
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label>Tiempo de alimentos (mm)</label>
                            <?= Html::activeInput('text',$model,'freeTime',['class'=>'form-control input-sm required']); ?>
                        </div>    
                        <div class="col-md-6 form-group">
                            <label>Días de prueba</label>
                            <?= Html::activeInput('text',$model,'testDays',['class'=>'form-control input-sm numberField','readonly'=>'readonly']); ?>
                        </div>                    
                    </div>
                    <div class="row">
                        <div class="col-md-4 form-group">
                            <label>Salarios</label>
                            <input readonly type='text' class='form-control numberField2 fiscalSalary input-sm' value='<?= $model->employee->salaries ?>'>
                        </div>      
                        <div class="col-md-4 form-group">
                            <label>Salario mínimo</label>
                            <div class="input-group input-group-sm">
                                <span class='input-group-addon'>$</span>
                                <input type='text' class='form-control input-sm numberField2 minimumSalary' value='<?= SettingsComponent::getSetting('minimumSalary') ?>' readonly>
                            </div>
                        </div>      
                    </div>
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Salario diario</label>
                            <div class="input-group input-group-sm">
                                <span class='input-group-addon'>$</span>
                                <input readonly type='text' class='form-control numberField2 fiscalSalary' value='<?= $model->employee->fiscalSalary ?>'>
                            </div>
                        </div>      
                        <div class="col-md-6 form-group">
                            <label>Salario mensual</label>
                            <div class="input-group input-group-sm">
                                <span class='input-group-addon'>$</span>
                                <input readonly type='text' class='form-control numberField2 fiscalMonthlySalary' value='<?= $model->employee->fiscalMonthlySalary ?>'>
                            </div>
                        </div>      
                    </div> 
                    <div class="form-group">
                        <button type='submit' class='btn btn-primary'>Guardar</button>
                        <a id='contractPreview' href='<?= Url::to(['contracts/preview']) ?>' class='btn btn-info'>Imprimir</a>
                        <button type='button' class='btn btn-default pull-right' data-dismiss='modal'>Cerrar</button>
                    </div>
                </form>
            </div>
            <div class="tab-pane">
                <h3>Contratos</h3>
                <hr>
                <table class='table table-condensed table-bordered table-striped'>
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Inicia</th>
                            <th>Vence</th>
                            <th>Días</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($model->employee->contracts as $cont): ?>
                            <tr>
                                <td><?= $cont->contractType->name ?></td>
                                <td><?= Yii::$app->controller->validDate($cont->getDateField('startDate'))?$cont->getDateField('startDate','d/m/Y'):'--/--/----'?></td>
                                <td><?= Yii::$app->controller->validDate($cont->getDateField('endDate'))?$cont->getDateField('endDate','d/m/Y'):'--/--/----'?></td>
                                <td><?= $cont->days; ?></td>
                            </tr>
                        <?php endforeach ?>
                        <?php if (count($model->employee->contracts)==0): ?>
                            <tr>
                                <td class="text-center" colspan="4">Sin contratos</td>
                            </tr>
                        <?php endif ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div id='warning-preview-contract' class="modal fade" tabindex="-1" role="dialog">
  <div class="modal-body">
      <h5>Tu contrato aun no se ha guardado</h5>       
  </div>
  <div class="modal-footer">
       <button type="button" class="btn btn-default" data-dismiss="modal">Continuar</button>
  </div>                                        
</div>