<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Contract;
use app\models\Department;
use app\models\Job;
use app\models\ContractType;
$jobs = Job::find()->all();
$departments = Department::find()->all();
$contractTypes = ContractType::find()->all();
 ?>
<div class="container">
    <h1 class='h2'>
    	Contratos
    </h1>
    <?php $auxId = Yii::$app->security->generateRandomString(5) ?>
    <form id='<?= $auxId ?>' class='filters-form'>
        <h4>Filtros</h4>
        <div class="row">
            <div class="col-md-2 form-group">
                <label>Empleado</label>
                <input type='text' name='col0' class='form-control input-sm'>
            </div>
            <div class="col-md-2 form-group">
                <label>Departamento</label>
                <?= Html::dropDownList('col1','',ArrayHelper::map($departments,'id','name'),['class'=>'form-control input-sm','prompt'=>'Seleccionar']) ?>
            </div>
            <div class="col-md-2 form-group">
                <label>Puesto</label>
                <?= Html::dropDownList('col2','',ArrayHelper::map($jobs,'id','name'),['class'=>'form-control input-sm','prompt'=>'Seleccionar']) ?>
            </div>
            <div class="col-md-2 form-group">
                <label>Tipo</label>
                <?= Html::dropDownList('col3','',ArrayHelper::map($contractTypes,'id','name'),['class'=>'form-control input-sm','prompt'=>'Seleccionar']) ?>
            </div>
            <div class="col-md-2 form-group">
                <label>Empresa</label>
                <?= Html::dropDownList('col7','',ArrayHelper::map(Yii::$app->user->identity->companies,'id','name'),['class'=>'form-control input-sm','prompt'=>'Seleccionar']) ?>
            </div>
        </div>
    </form>
    <hr>
    <table data-filters="#<?= $auxId ?>" data-ajax-url='<?= Url::toRoute('contracts/listing') ?>' class='hasDataTableAjax table table-condensed table-bordered table-striped'>
        <thead>
            <tr>
                <th>Empleado</th>
                <th>Departamento</th>
                <th>Puesto</th>
                <th>Tipo</th>
                <th>Salario mensual</th>
                <th>Inicia</th>
                <th>Vence</th>
                <th>Acciones</th>
            </tr>
        </thead>
    </table>
</div>