<?php 
namespace app\models;

use Yii;
use yii\helpers\ArrayHelper;
use app\models\BaseModel;
use app\models\Incident;
use app\components\IncidentCategoriesComponent;

class PermissionRequest extends BaseModel{
	public static function tableName(){
		return "PermissionRequests";
	}
	public function rules(){

		return [
			[[	
				'idEmployee',
				'daysToUse',
				'startDate',
				'idIncidentCategory',
			],'required','message'=>'El campo <strong>{attribute}</strong> es obligatorio'],
			[[
				'daysToUse',
			],'number','message'=>'El campo <strong>{attribute}</strong> debe ser un numero'],
			[['notes'],'safe']
		];	
	}
	public function attributeLabels()
	{
		return [
			'idEmployee'=>'Empleado',
			'idJob'=>'Puesto',
			'idDepartment'=>'Departamento',
			'daysToUse'=>'Dias a disfrutar',
			'requiredBreakDays'=>'Descanso obligatorio',
			'idIncidentCategory'=>'Tipo de permiso',
			'startDate'=>'Fecha de inicio',
		];
	}
	public function getEmployee()
	{
		return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
	}
	public function getDepartment()
	{
		return $this->hasOne(Department::classname(),['id'=>'idDepartment']);
	}
	public function getJob()
	{
		return $this->hasOne(Job::classname(),['id'=>'idJob']);
	}
	public function getIncidentCategory()
	{
		return $this->hasOne(IncidentCategory::classname(),['id'=>'idIncidentCategory']);
	}
	public function beforeSave($insert)
    {
    	if (parent::beforeSave($insert)) {
            if(empty($this->idCreationUser)) $this->idCreationUser = Yii::$app->user->identity->id;
			$this->idJob = $this->employee->idJob;
			$this->idDepartment = $this->employee->idDepartment;
    		return true;
    	} else {
    		return false;
    	}
    }
    public static function findbyCompany($companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->joinWith('employee')->where(['Employees.idCompany'=>$companyId]);
    }
	public function afterDelete()
	{
	    parent::afterDelete();
    	$incs = Incident::find()
		->where(['idRequest'=>$this->id,'requestType'=>Incident::REQUEST_TYPE_PERMISSION])
		->all();
		$idAs = IncidentCategoriesComponent::get('-');
		$idPSG = IncidentCategoriesComponent::get('PSG');
		$idPCG = IncidentCategoriesComponent::get('PCG');
		foreach ($incs as $inc) {
			$inc->idRequest = -1;
			if(in_array($inc->idIncidentCategory, [$idPSG,$idPCG])) $inc->idIncidentCategory = $idAs;
			$inc->save();
		}
	}
    public function getRequiredBreakDays()
    {
    	$aux = json_decode($this->jsonRequiredBreakDays);
    	return $aux?$aux:[];
    }
	public function getDaysToUseWithBreaks()
	{
		return $this->daysToUse+$this->requiredBreakDaysNumber;
	}
}

?>