<?php 
namespace app\models;
use Yii;
use app\models\BaseModel;

class Period extends BaseModel{
	const STATUS_OPEN = 1;
	const STATUS_CLOSE = 2;
	const STATUS_REVIEW = 3;
	public static $statusOptions = [
		self::STATUS_OPEN => 'Abierto',
		self::STATUS_CLOSE => 'Cerrado',
		self::STATUS_REVIEW => 'Revisión',
	];
	public static function tableName()
	{
		return 'Periods';
	}
	public function rules()
	{
		return [
			[['startDate','endDate','idCompany'],'required','message'=>'Campo <strong>{attribute}</strong> obligatorio'],
			['startDate','checkDates'],
		];
	}
	public function checkDates($attribute,$params)
	{
		// verificar que el periodo no choca con otros
		if($this->isNewRecord){
			if(Period::findByCompany($this->idCompany)->andWhere("startDate <= '{$this->endDate}' AND endDate >= '{$this->startDate}'")->count())
				$this->addError('startDate',"Algunas fechas de este periodo ya se encuentran en periodos previos");			
		}
	}
	public function getCompany()
	{
		return $this->hasOne(Company::classname(),['id'=>'idCompany']);
	}
	public function getUserClosure()
	{
		return $this->hasOne(User::classname(),['id'=>'idUserClosure']);
	}
	public function getUserAproval()
	{
		return $this->hasOne(User::classname(),['id'=>'idUserAproval']);
	}
}
 ?>