<?php 
namespace app\models;
use Yii;
use yii\db\ActiveRecord;

class IncidentCategory extends ActiveRecord{
    const TYPE_POSITIVE = 1;
    const TYPE_NEGATIVE = 2;
    public static $typeOptions = [
        self::TYPE_POSITIVE => 'positivo',
        self::TYPE_NEGATIVE => 'negativo',
    ];
    public function init()
    {
        if($this->isNewRecord){
        }
        return parent::init();
    }
	public static function tableName()
	{
		return 'IncidentCategories';
	}
	public function rules()
	{
		return [
			[['name','tag','type'],'required','message'=>'Campo <strong>{attribute}</strong> obligatorio'],
			[['name','tag'],'unique','message'=>'Ya existe una categoría con el nombre <strong>"{value}"</strong>'],
			[['description'],'safe'],
		];
	}
    public function attributeLabels()
    {
        return [
            'name'=>"Nombre",
            'description'=>"Descripción",
        ];
    }
    public function getParentCategoryName()
    {
        return $this->parentCategory?$this->parentCategory->name:"";
    }
    public function getParentCategory()
    {
    	return $this->hasOne(IncidentCategory::classname(),['id'=>'idIncidentCategoryParent'])->from(['parentTable'=>IncidentCategory::tablename()]);
    }
    public function getChildrenCategories()
    {
    	return $this->hasMany(IncidentCategory::classname(),['idIncidentCategoryParent'=>'id'])->from(['childsTable'=>IncidentCategory::tablename()]);
    }
    public function getTypeOptions()
    {
        return [
            self::TYPE_POSITIVE => "Aumento",
            self::TYPE_NEGATIVE => "Descuento",
        ];
    }
}
 ?>