<?php 
namespace app\models;
use Yii;
use yii\db\ActiveRecord;
use app\models\BaseModel;

class Incident extends BaseModel{
    const REQUEST_TYPE_VACATION = 1;
    const REQUEST_TYPE_PERMISSION = 2;
    const REQUEST_TYPE_NOTICE = 3;

    public static $requestTypeOptions = [
        self::REQUEST_TYPE_VACATION => 'Papeleta de vacaciones',
        self::REQUEST_TYPE_PERMISSION => 'Papeleta de permisos',
        self::REQUEST_TYPE_NOTICE => 'Papeleta de avisos',   
    ];
    public function init()
    {
        if($this->isNewRecord){
            // $this- = 0;
        }
        return parent::init();
    }
	public static function tableName()
	{
		return 'Incidents';
	}
	public function rules()
	{
		return [
			[['idEmployee','idIncidentCategory','date'],'required','message'=>'Campo <strong>{attribute}</strong> obligatorio'],
            [['idEmployee','date'],'unique','targetAttribute'=>['date','idEmployee']],
            ['notes','safe'],
		];
	}
    public function beforeSave($insert)
    {
    	if (parent::beforeSave($insert)) {
            $this->updateDate = date('Y-m-d H:i:s');
            $this->updateUser = Yii::$app->user->identity->id;
            if(empty($this->creationUser)) $this->creationUser = $this->updateUser;
    		return true;
    	} else {
    		return false;
    	}
    }
    public function attributeLabels()
    {
        return [
            'idEmployee'=>"Empleado",
            'idIncidentCategory'=>"Categoría",
            'description'=>"Descripción",
        ];
    }
    public function getEmployee()
    {
        return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
    }
    public function getIncidentCategory()
    {
    	return $this->hasOne(IncidentCategory::classname(),['id'=>'idIncidentCategory']);
    }
    public function getPeriod()
    {
        return Period::find()
        ->where(['idCompany'=>$this->employee->idCompany])
        ->andWhere("startDate <= '{$this->date}' AND endDate >= '{$this->date}'")
        ->one();
    }
}
 ?>