<?php 
namespace app\models;

use Yii;
use yii\db\ActiveRecord; 

class Holiday extends ActiveRecord{
	public static function tableName(){
		return "Holidays";
	}
	public function rules(){

		return [
			[['date','description'],'required'],
		];
	}
	public function getId()
	{
		return $this->date;
	}
	public function afterDelete()
	{
	    parent::afterDelete();
		$idHol = IncidentCategory::findOne(['tag'=>'DF'])->id;
		$idAs = IncidentCategory::findOne(['tag'=>'-'])->id;
	    $incs = Incident::find()
		->where(['date'=>$this->date,'idIncidentCategory'=>$idHol])
		->all();
		foreach ($incs as $inc) {
			if($inc->period && $inc->period->status==Period::STATUS_OPEN){
				$inc->idIncidentCategory = $idAs;
				$inc->save();
			}
		}
	}
}

?>