<?php 
namespace app\models;
use Yii;
use app\models\BaseModel;

class Department extends BaseModel{
	public static function tableName()
	{
		return 'Departments';
	}
	public function rules()
	{
		return [
			[['name'],'required','message'=>'Campo <strong>{attribute}</strong> obligatorio'],
			['name','unique','message'=>'Este nombre ya se ha usado'],
			[['description'],'safe'],
		];
	}
    public function attributeLabels()
    {
        return [
            'name'=>"Nombre",
            'description'=>"Descripción",
        ];
    }
    public function getEmployees()
    {
    	$this->hasMany(Employee::classname(),['idDepartment'=>'id']);
    }
}
 ?>