<?php 
namespace app\models;
use Yii;
use app\models\BaseModel;
use app\models\BaseQuery;
use app\components\EmployeesComponent;
use yii\helpers\ArrayHelper;

class Contract extends BaseModel{
    public function init()
    {
        if($this->isNewRecord){
            $this->salary=0;
            $this->salaries=0;
            $this->testDays=0;
        }
        return parent::init();
    }
	public static function tableName()
	{
		return 'Contracts';
	}
	public function rules()
	{
		return [
			[['idEmployee','idDepartment','salaries','minimumSalary','idContractType','idJob','startDate','freeTime','testDays'],'required','message'=>'Campo <strong>{attribute}</strong> obligatorio'],
            [['startDate'],'date','format'=>'yyyy-mm-dd','message'=>"La fecha del campo <strong>{attribute}</strong> no es valida"],
            ['idContractType','exist','targetClass'=>"\app\models\ContractType",'targetAttribute'=>'id','message'=>'El campo <strong>{attribute}</strong> no es valido'],
			[['salary','salaries','minimumSalary','testDays','freeTime'],'number','message'=>'Campo {attribute} debe ser un número'],
            [['entryDateCompany','entryDateSaav','endDate','salary'],'safe']
		];
	}
    public function scenarios()
    {
        $scenarios = parent::scenarios();
        return $scenarios;
    }
    public function beforeSave($insert)
    {
    	if (parent::beforeSave($insert)) {
            $this->updateDate = date('Y-m-d H:i:s');
            $this->updateUser = Yii::$app->user->identity->id;
            if(empty($this->creationUser)) $this->creationUser = $this->updateUser;
    		return true;
    	} else {
    		return false;
    	}
    }
    public function attributeLabels()
    {
        return [
            'startDate'=>"Fecha de inicio",
            'endDate'=>"Fecha fin",
            'entryDateCompany'=>"Fecha de ingreso a la empresa",
            'entryDateSaav'=>"Fecha de ingreso a SAAV",
            'entryDateImss'=>"Fecha de ingreso al imss",
            'job'=>"Puesto",
            'idContractType'=>"Tipo de contrato",
            'idEmployee'=>"Empleado",
            'idDepartment'=>"Departamento",
            'salary'=>"Sueldo fiscal",
            'salaries'=>"Salarios",
            'minimumSalary'=>"Salario mínimo",
            'testDays'=>"Días de prueba",
            'freeTime'=>"Tiempo de alimentos",
        ];
    }
    public function getFiscalSalary()
    {
        return $this->salaries*$this->minimumSalary;
    }
    public function getFiscalMonthlySalary()
    {
        return $this->fiscalSalary*365/12;
    }
    public function getEmployee()
    {
        return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
    }
    public function getContractType()
    {
    	return $this->hasOne(ContractType::classname(),['id'=>'idContractType']);
    }
    public function getDepartment()
    {
        return $this->hasOne(Department::classname(),['id'=>'idDepartment']);
    }
    public function getJob()
    {
    	return $this->hasOne(Job::classname(),['id'=>'idJob']);
    }
    public static function findbyCompany($companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->joinWith('employee')->where(['Employees.idCompany'=>$companyId]);
    }
    public static function findOneByCompany($id,$companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->joinWith('employee')->where(['Employees.idCompany'=>$companyId,self::tableName().'.id'=>$id])->one();
    }
    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);
    }
    public function getDays()
    {
        $startDate = $this->getDateField('startDate');
        $endDate = $this->getDateField('endDate');
        if($this->validDate($startDate) && $this->validDate($endDate)){
            return $endDate->diff($startDate)->days+1;
        }
        return "N/A";
    }
}

// class ContractQuery extends BaseQuery
// {
//     public function byCompany($companyId = false)
//     {
//         $companyId = $companyId===false?Yii::$app->user->identity->currentCompany->id:$companyId; 
//         return $this->joinWith('employee')->andWhere([Employee::tableName().'.idCompany' => $companyId]);

//     }
// }
?>