<?php 
namespace app\models;
use Yii;
use yii\db\ActiveRecord;
use app\models\BaseQuery;
use yii\helpers\ArrayHelper;

class BaseModel extends ActiveRecord{
    public function getEnumField($field)
    {
        $fieldOption = $field.'Options';
        $className = get_called_class();
        $options = $className::$$fieldOption;
        return $options[$this->$field];
    }
    public function getDateField($field,$format=false)
    {
        $aux = new \DateTime($this->$field);
        if($format===false) return $aux;
        return empty($this->$field) || strpos($this->$field, '0000-00-00')!==false?'--/--/----':$aux->format($format);
    }
    public static function findbyCompany($companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->where(['idCompany'=>$companyId]);
    }
    public static function findOneByCompany($id,$companyId=false)
    {
    	$companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
    	return parent::find()->where(['idCompany'=>$companyId,'id'=>$id])->one();
    }
    public function getFullDateField($field,$time=false)
    {
        $date =  new \DateTime($this->$field);
        $months = ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
        $day = $date->format('d');
        $month = $months[intval($date->format('m'))-1];
        $year = $date->format('Y'); 
        return $day.' de '.$month.($year<2000?' de ':' del ').$year.($time?" a las ".$date->format("H:i")." hrs":'');
    }
    public function validDate($dateTimeObj)
    {
        $day = intval($dateTimeObj->format('d'));
        $month = intval($dateTimeObj->format('m'));
        $year = intval($dateTimeObj->format('Y'));
        return checkdate($month, $day, $year);
    }
}
?>