<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use app\models\LoginForm;
use app\models\Company;

class SiteController extends Controller
{
    public function actionIndex()
    {
        return $this->render('index');
    }
    public function actionLogin()
    {
        if (!\Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            // crear variable de compañia
            $companies = Yii::$app->user->identity->companies;
            if(count($companies)==1) Yii::$app->session->set('currentCompanyId',$companies[0]->id);
            return $this->goBack();
        }
        return $this->renderPartial('login', [
            'model' => $model,
        ]);
    }
    public function actionConstruction()
    {
        return $this->render('construction');
    }
    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }
    public function actionTest()
    {
        return date('Y-m-d H:i:s');
    }
}
