<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use app\models\Incident;
use app\models\Company;
use app\models\User;
use app\models\IncidentCategory;
use app\models\Period;
use app\models\Employee;
use app\models\PayrollConcept;
use app\components\IncidentsComponent;
use app\components\PayrollConceptsComponent;
use app\components\PeriodsComponent;

class PayrollConceptsController extends Controller
{
	public function actionCalendar()
	{
		$req = Yii::$app->request;
		$period = Period::findOneByCompany($req->get('period'));
		if($period){
			$departmentId = $req->get('department');
			
			if(Yii::$app->user->identity->isAdmin()) $depsQuery = $period->company->getDepartments();
			else $depsQuery = Yii::$app->user->identity->getDepartments($period->company->id);

			if($departmentId>-1) $depsQuery->andWhere(['id'=>$departmentId]); 
			$departments = $depsQuery->all();

			$idDepartments = ArrayHelper::map($departments,'id','id');

			$employees = PeriodsComponent::getActiveEmployees($period,$idDepartments);

			return $this->renderPartial('calendar',[
				'period'=>$period,
				'employees'=>$employees,
			]);
		}else{
			return "<h1>No se ha encontrado periodo</h1>";
		}
	}
	public function actionExport($company,$period,$department)
	{
		$period = Period::findOneByCompany($period);
		$incidentCategories = IncidentCategory::find()->all();
		$departmentId = $department;
		
		if(Yii::$app->user->identity->isAdmin()) $depsQuery = $period->company->getDepartments();
			else $depsQuery = Yii::$app->user->identity->getDepartments($period->company->id);

			if($departmentId>-1) $depsQuery->andWhere(['id'=>$departmentId]); 
			$departments = $depsQuery->all();

			$idDepartments = ArrayHelper::map($departments,'id','id');

			$employees = PeriodsComponent::getActiveEmployees($period,$idDepartments);
			
		$html = $this->renderPartial('calendar-pdf',[
				'period'=>$period,
				'employees'=>$employees,
		]);
		// return $html;
		$pdf = $this->getPdf($html);
		$pdf->Output("Incidencias.pdf",'I');
	}
	public function getPdf($html)
	{
		ob_start();
		$pdf = new \TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		$pdf->SetFont('dejavusans','',10);
		$pdf->SetMargins(8,8,8);
		// $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		// $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$pdf->AddPage();
		$pdf->writeHTML($html,true,false,false,false,'');
		$pdf->lastPage();
		ob_end_clean();
		return $pdf;
	}
	public function actionSavePeriod($id)
	{
		$r = ['success'=>false];
		$data = Yii::$app->request->post('data');
		$period = Period::findOneByCompany($id);
		if($period->status==Period::STATUS_OPEN || Yii::$app->user->identity->isAdmin()){
			foreach ($data as $employeeId => $concepts) {
				$employeeConcepts = PayrollConceptsComponent::getEmployeeConcepts($employeeId,$period->id);
				if(isset($employeeConcepts)){
					foreach ($concepts as $key=>$value){
						if($employeeConcepts->$key!=$value) $employeeConcepts->$key = $value;
					}
				}else{
					$employeeConcepts = new PayrollConcept;
					$employeeConcepts->idEmployee = $employeeId;
					$employeeConcepts->idPeriod = $period->id;
					foreach ($concepts as $key=>$value) $employeeConcepts->$key = $value; // verificar si es un atributo valido
				}
				$employeeConcepts->save();
			}			
			$r['success']=true;
			$r['message']="Se han actualizado los conceptos ";
		}else{
			$r['message']="Periodo cerrado, no es posible modificar.";
		}
		return json_encode($r);
	}
	public function actionEmployeeListing($id)
	{
    	$models = Incident::find()->where(['idEmployee'=>$id])->joinWith(['incidentCategory']);//->addSelect(["*","(salaries*minimumSalary) AS fiscalSalary"]);
		$cols = ['IncidentCategories.name','amount','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if($_GET['columns'][$index]['search']['value']) $models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		// echo $models->createCommand()->sql;
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['incidents/edit','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' ><i class='fa fa-eye'></i></a>";
			$actions[]="<a href='".Url::to(['incidents/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				$m->incidentCategory->name.($m->incidentCategory->parentCategoryName?" - ".$m->incidentCategory->parentCategoryName:""),
				"$".number_format($m->amount,2),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);		
	}
	public function actionListing()
    {
		$models = Incident::find()->joinWith(['incidentCategory']);//->addSelect(["*","(salaries*minimumSalary) AS fiscalSalary"]);
		$cols = ['IncidentCategories.name','amount','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if($_GET['columns'][$index]['search']['value']) $models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		// echo $models->createCommand()->sql;
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['incidents/edit','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' ><i class='fa fa-eye'></i></a>";
			$actions[]="<a href='".Url::to(['incidents/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				date('d/m/Y',strtotime($m->date)),
				$m->incidentCategory->name.($m->incidentCategory->parentCategoryName?" - ".$m->incidentCategory->parentCategoryName:""),
				"$".number_format($m->amount,2),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);		

    }
    public function notifyAdmins($period)
    {
    	// usuarios con permiso a la empresa
    	$users = User::find()
    	->joinWith('companies')
    	->where(["Companies.id"=>$period->idCompany,'role'=>[User::ROLE_MANAGER,User::ROLE_EXECUTIVE]])
    	->all();

    	$emails=[];
        foreach ($users as $u) $emails[] = $u->email;    	
    	// $emails=['uicab2593@gmail.com'];

	    return Yii::$app->mailer->compose()
        ->setFrom('sistema@lamhi.com.mx')
        ->setTo($emails)
        ->setSubject('Notificación de cierre de incidencias')
        ->setHtmlBody($this->renderPartial('notify-email',['period'=>$period]))
        ->send();
    }
    public function notifyManager($period)
    {
    	// usuarios con permiso a la empresa
	    return Yii::$app->mailer->compose()
        ->setFrom('sistema@lamhi.com.mx')
        ->setTo(SettingsComponent::getSetting('managerEmail'))
        ->setSubject('Notificación de aprobación de incidencias')
        ->setHtmlBody($this->renderPartial('notify-manager-email',['period'=>$period]))
        ->send();
    }
    public function actionTest()
    {
    	// $this->notifyManager(Period::findOne(209));
    	// $r = Yii::$app->mailer->compose()
     //    ->setFrom('sistema@lamhi.com.mx')
     //    ->setTo('uicab2593@gmail.com')
     //    ->setSubject('prueba correo')
     //    ->setHtmlBody("<h1>prueba correo</h1>")
     //    ->send();
     //    var_dump($r);
    	// $deps = IncidentsComponent::getDepartmentsUncharged(Period::findOne(209));
    	// var_dump($deps);
    }
}