<?php 
namespace app\controllers;

use \Yii;
use app\components\Controller;
use app\models\MinimumSalary;

class MinimumSalariesController extends Controller{
	public $primaryModel = "\app\models\MinimumSalary";
	public $newTitle = "Salario mínimo";

	public function actionCreate(){
		$r=['success'=>false];
		$hol = new MinimumSalary();
		$hol->attributes = $this->req->post('MinimumSalary');
		if($hol->save()) $r['success']=true;
		return json_encode($r);
	}
	public function actionUpdate($id=false)
	{
		$r=['success'=>false];
		$hol = MinimumSalary::findOne($id);
		$hol->attributes = $this->req->post('MinimumSalary');
		if($hol->save()) $r['success']=true;
		return json_encode($r);
	}
	public function actionListing()
    {
    	$models = MinimumSalary::find();
		$cols = ['startDate','amount','startDate'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=$this->generateHtmlActions($m);
			$r['data'][]=[
				$m->getDateField('startDate','d/m/Y'),
				number_format($m->amount,2),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
    public function actionDelete($id)
    {
        $m = MinimumSalary::findOne($id);
        if($m) $m->delete();
        return json_encode(['success'=>true,'callbackScript'=>'reloadAjaxTables();']);
    }
    public function actionEdit($id)
	{
		$d = MinimumSalary::findOne($id);
		return $this->renderModal('edit','Editar registro',['model'=>$d]);
	}
}
 ?>
