<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use app\models\Job;

class JobsController extends Controller
{
	public $primaryModel = "\app\models\Job";
	public $newTitle = "Nuevo Puesto";
	public function actionCreate()
	{
        $r = ['success'=>false];
        $model = new Job;
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $r['success']=true;
        }else{
            $aux = $model->getErrors();
            $r['message']=reset($aux)[0];
        }            
        return json_encode($r);
	}
	public function actionEdit($id)
	{
		$d = Job::findOne($id);
		return $this->renderModal('edit','Editar registro',['model'=>$d]);
	}
	public function actionDelete($id)
    {
        Job::findOne($id)->delete();
        return json_encode(['success'=>true,'callbackScript'=>'reloadAjaxTables();']);
    }
	public function actionUpdate($id)
    {
    	$r = ['success'=>false];
    	$model = Job::findOne($id);
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $r['success']=true;
        }else{
            $aux =$model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
    }
	public function actionListing()
    {
    	$models = Job::find();
		$cols = ['name','description','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=$this->generateHtmlActions($m);
			$r['data'][]=[
				$m->name,
				$m->description,
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
}