<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use app\models\Incident;
use app\models\Company;
use app\models\User;
use app\models\IncidentCategory;
use app\models\Period;
use app\models\Employee;
use app\components\IncidentsComponent;
use app\components\PeriodsComponent;
use app\components\PayrollConceptsComponent;

class IncidentsController extends Controller
{
	public $primaryModel = "\app\models\Incident";
	public function actionCalendar()
	{
		$req = Yii::$app->request;
		$period = Period::findOneByCompany($req->get('period'));
		if($period){
			$idDepartment = $req->get('department',-1);
			
			if(Yii::$app->user->identity->isAdmin()) $depsQuery = $period->company->getDepartments();
			else $depsQuery = Yii::$app->user->identity->getDepartments($period->company->id);

			if($idDepartment>-1) $depsQuery->andWhere(['id'=>$idDepartment]); 
			$departments = $depsQuery->all();

			$idDepartments = ArrayHelper::map($departments,'id','id');

			$employees = PeriodsComponent::getActiveEmployees($period,$idDepartments);

			return $this->renderPartial('calendar',[
					'period'=>$period,
					'employees'=>$employees,
					'idDepartment'=>$idDepartment,
			]);
		}else{
			return "<h1>No se ha encontrado periodo</h1>";
		}
	}
	public function actionExport($period,$department)
	{
		$period = Period::findOneByCompany($period);
		$incidentCategories = IncidentCategory::find()->all();
		$departmentId = $department;
		
		if(Yii::$app->user->identity->isAdmin()) $depsQuery = $period->company->getDepartments();
		else $depsQuery = Yii::$app->user->identity->getDepartments($period->company->id);

		if($departmentId>-1) $depsQuery->andWhere(['id'=>$departmentId]); 
		$departments = $depsQuery->all();

		$idDepartments = ArrayHelper::map($departments,'id','id');

		$employees = PeriodsComponent::getActiveEmployees($period,$idDepartments);
		
		$html = $this->renderPartial('calendar-pdf',[
			'period'=>$period,
			'employees'=>$employees,
		]);
		// return $html;
		$pdf = $this->getPdf($html);
		$pdf->Output("Incidencias.pdf",'I');
	}
	public function getPdf($html)
	{
		ob_start();
		$pdf = new \TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		$pdf->SetFont('dejavusans','',8);
		$pdf->SetMargins(8,8,8);
		// $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		// $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$pdf->AddPage();
		$pdf->writeHTML($html,true,false,true,false,'');
		$pdf->lastPage();
		ob_end_clean();
		return $pdf;
	}
	public function actionAproval($id)
	{
		$period = Period::findOneByCompany($id);
		$r=['success'=>false];
		if(Yii::$app->user->identity->isAdmin()){
			$period->status = Period::STATUS_CLOSE;
			$period->aprovalDate = date('Y-m-d H:i:s');
			$period->idUserAproval = Yii::$app->user->identity->id;
			$period->save();
			$this->notifyManager($period);
			$r['success']=true;
			$r['callbackScript']="
				$('#incidentsCalendarForm .btn-consult').click();
			";
			$r['message']="Incidencias cerradas con éxito";
		}
		return json_encode($r);
	}
	public function actionSendReview($id)
	{
		$period = Period::findOneByCompany($id);
		$r=['success'=>false];
		if($this->isLastPeriod($period)){
			if($period->status==Period::STATUS_OPEN){
				$depsUncharged = IncidentsComponent::getDepartmentsUncharged($period);
				if(count($depsUncharged)==0){
					$depsUncharged = PayrollConceptsComponent::getDepartmentsUncharged($period);
					if(count($depsUncharged)==0){
	    				$this->closePrevPeriods($period);
						$period->status = Period::STATUS_REVIEW;
						$period->idUserClosure = Yii::$app->user->identity->id;
						$period->closureDate = date('Y-m-d H:i:s');
						$period->incidentsLastDate = $_POST['closeDate'];
						$period->save();
						$r['success']=true;
						$r['callbackScript']="
							$('#incidentsCalendarForm .btn-consult').click();
						";					
	    				$this->notifyAdmins($period);						
					}else{
						$message = "No se han cargado conceptos de los siguientes departamentos:<br><ul>";
						foreach ($depsUncharged as $dep) $message.="<li>{$dep->name}</li>";
						$message.="</ul>";
						$r['message']=$message;						
					}
				}else{
					$message = "No se han cargado incidencias de los siguientes departamentos:<br><ul>";
					foreach ($depsUncharged as $dep) $message.="<li>{$dep->name}</li>";
					$message.="</ul>";
					$r['message']=$message;
				}
			}else{
				$r['message']="El periodo ya ha sido cerrado";
			}
		}else{
			$r['message']="Se deben cerrar periodos anteriores";
		}
		return json_encode($r);
	}
	public function closePrevPeriods($period)
	{
		// busca periodos con idas no cerrados y los cierra
		$prevPeriod = $period->company->lastClosedPeriod;
		if($prevPeriod){
			// $prevPeriod->incidentsLastDate = $prevPeriod->endDate;
			$prevPeriod->closeAllDays = True;
			$prevPeriod->save();			
		}
	}
	// public function actionIndex()
	// {
	// 	$periodId = Yii::$app->request->get('period');
	// 	$period = Period::findOneByCompany($periodId);
	// 	$incidentCategories = IncidentCategory::find()->orderBy('tag ASC')->all();
	// 	if($period){
	// 		return $this->render('calendar',[
	// 			'period'=>$period,
	// 			'prevPeriod'=>Period::findOne(['idCompany'=>$period->idCompany,'endDate'=>date('Y-m-d',strtotime($period->startDate.' -1 day'))]),
	// 			'nextPeriod'=>Period::findOne(['idCompany'=>$period->idCompany,'startDate'=>date('Y-m-d',strtotime($period->endDate.' +1 day'))]),
	// 			'incidentCategories'=>$incidentCategories,
	// 		]);			
	// 	}
	// }
	public function actionCompanies()
	{
		return $this->render('companies',['companies'=>Yii::$app->user->identity->companies]);
	}
	public function actionCompanyOptions()
	{
		$company = Yii::$app->user->identity->getCompanies()->andWhere(['id'=>$_POST['company']])->one();
		if($company){
			$periods = [];
			$firstOpenPeriod = false;
			foreach ($company->getPeriods()->orderBy('startDate ASC')->all() as $p) {
				$selected = false;
				if($p->status==Period::STATUS_OPEN && $firstOpenPeriod==false){
					$selected=true;
					$firstOpenPeriod=true;
				}
				$periods[]=[
					'label'=>$p->getDateField('startDate')->format('d/m/Y').' - '.$p->getDateField('endDate')->format('d/m/Y').' / '.$p->getEnumField('status'),
					'value'=>$p->id,
					'selected'=>$selected,
				];
			}
			$departments = [['label'=>'Todos','value'=>'-1']];
			if(Yii::$app->user->identity->isAdmin()) $deps = $company->departments;
			else $deps = Yii::$app->user->identity->getDepartments($company->id)->all();
			foreach ($deps as $d) {
				$departments[]=[
					'label'=>$d->name,
					'value'=>$d->id,
				];
			}
		}
		return json_encode(['periods'=>$periods,'departments'=>$departments]);
	}
	public function isLastPeriod($period)
	{
		$prevOpenPeriods = Period::find()
		->where(['idCompany'=>$period->idCompany,'status'=>[Period::STATUS_OPEN,Period::STATUS_REVIEW]])
		->andWhere("startDate<'{$period->startDate}'")
		->count();
		return $prevOpenPeriods==0;
	}
	public function actionSavePeriod($id)
	{
		$r = ['success'=>false];
		$data = Yii::$app->request->post('data');
		$period = Period::findOneByCompany($id);
		$validDates = false;
		foreach ($data as $employeeId => $dates) {
			$preDates = IncidentsComponent::getEmployeeIncidents($employeeId,$period);
			foreach ($dates as $date => $incidentCategoryId) {
				$validDates=true;
				if(isset($preDates[$date])){
					// la incidencia ya existe, actualiza objeto
					if($preDates[$date]->idIncidentCategory!=$incidentCategoryId){
						$preDates[$date]->idIncidentCategory = $incidentCategoryId; 
						$preDates[$date]->save();
					}else if($preDates[$date]->isNewRecord){
						$preDates[$date]->save();
					}
				}else{
					// crea nuevo objeto
					$incident = new Incident;
					$incident->idEmployee = $employeeId;
					$incident->idIncidentCategory = $incidentCategoryId;
					$incident->date = $date;
					$incident->save();
				}
			}
		}
		$r['success']=true;
		$r['message']=$validDates?"Se ha actualizado el calendario":"No existen modificaciones";
		$r['callbackScript']="
			$(\"a[href='#confirmSendReview']\").attr('disabled',false).removeClass('disabled');
		";

		return json_encode($r);
	}
	public function actionEmployeeListing($id)
	{
    	$models = Incident::find()->where(['idEmployee'=>$id])->joinWith(['incidentCategory']);//->addSelect(["*","(salaries*minimumSalary) AS fiscalSalary"]);
		$cols = ['IncidentCategories.name','amount','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if($_GET['columns'][$index]['search']['value']) $models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		// echo $models->createCommand()->sql;
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['incidents/edit','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' ><i class='fa fa-eye'></i></a>";
			$actions[]="<a href='".Url::to(['incidents/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				$m->incidentCategory->name.($m->incidentCategory->parentCategoryName?" - ".$m->incidentCategory->parentCategoryName:""),
				"$".number_format($m->amount,2),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);		
	}
	public function actionListing()
    {
		$models = Incident::find()->joinWith(['incidentCategory']);//->addSelect(["*","(salaries*minimumSalary) AS fiscalSalary"]);
		$cols = ['IncidentCategories.name','amount','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if($_GET['columns'][$index]['search']['value']) $models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		// echo $models->createCommand()->sql;
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['incidents/edit','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' ><i class='fa fa-eye'></i></a>";
			$actions[]="<a href='".Url::to(['incidents/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				date('d/m/Y',strtotime($m->date)),
				$m->incidentCategory->name.($m->incidentCategory->parentCategoryName?" - ".$m->incidentCategory->parentCategoryName:""),
				"$".number_format($m->amount,2),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);		

    }
    public function notifyAdmins($period)
    {
    	// usuarios con permiso a la empresa
    	$users = User::find()
    	->joinWith('companies')
    	->where(["Companies.id"=>$period->idCompany,'role'=>[User::ROLE_MANAGER,User::ROLE_EXECUTIVE]])
    	->all();

    	$emails=[];
        foreach ($users as $u) $emails[] = $u->email;    	
    	// $emails=['uicab2593@gmail.com'];

	    return Yii::$app->mailer->compose()
        ->setFrom('sistema@lamhi.com.mx')
        ->setTo($emails)
        ->setSubject('Notificación de cierre de incidencias')
        ->setHtmlBody($this->renderPartial('notify-email',['period'=>$period]))
        ->send();
    }
    public function notifyManager($period)
    {
    	// usuarios con permiso a la empresa
	    return Yii::$app->mailer->compose()
        ->setFrom('sistema@lamhi.com.mx')
        ->setTo('info@lamhi.com.mx')
        ->setSubject('Notificación de aprobación de incidencias')
        ->setHtmlBody($this->renderPartial('notify-manager-email',['period'=>$period]))
        ->send();
    }
    public function actionSendnotifadmin($id)
    {
    	$this->notifyAdmins(Period::findOne($id));
    }
    public function actionMenu()
    {
    	return $this->render('menu');
    }
}