<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use app\models\Department;
use app\models\Employee;
use app\models\Contract;

class DepartmentsController extends Controller
{
	public $primaryModel = "\app\models\Department";
	public $newTitle = "Nuevo Departamento";
	public function actionCreate()
	{
        $r = ['success'=>false];
        $model = new Department;
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $r['success']=true;
        }else{
            $aux =$model->getErrors();
            $r['message']=reset($aux)[0];
        }            
        return json_encode($r);
	}
	public function actionEdit($id)
	{
		$d = Department::findOne($id);
		return $this->renderModal('edit','Editar registro',['model'=>$d]);
	}
	public function actionDelete($id)
    {
        $dep = Department::findOne($id);
        return json_encode(['success'=>true,'callbackScript'=>'reloadAjaxTables();']);
    }
	public function actionUpdate($id)
    {
    	$r = ['success'=>false];
    	$model = Department::findOne($id);
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $r['success']=true;
        }else{
            $aux =$model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
    }
	public function actionByCompany()
	{
		$deps = Department::findByCompany(Yii::$app->request->post('id'))->all();
		$html = '';
		foreach ($deps as $d) {
			$html.="<option value='{$d->id}'>{$d->name}</option>";
		}
		return $html;
	}
	public function actionListing()
    {
    	$models = Department::find();
		$cols = ['name','description','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=$this->generateHtmlActions($m);
			$r['data'][]=[
				$m->name,
				$m->description,
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
}