<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use app\models\Contract;
use app\models\Employee;
use app\components\SettingsComponent;
use app\components\EmployeesComponent;
use yii\helpers\ArrayHelper;
use app\models\Department;

class ContractsController extends Controller
{
	public $primaryModel = "\app\models\Contract";
	public $newTitle = "Nuevo Contrato";
	public function actionPreview()
	{
		$contract = new Contract;
		$contract->attributes = $_GET['Contract'];
		$contract->idDepartment = $contract->employee->idDepartment;
        $contract->idJob = $contract->employee->idJob;
        $contract->minimumSalary = SettingsComponent::getSetting('minimumSalary');
        $contract->salaries = $contract->employee->salaries;
		$pdf = $this->getContractPdf($contract);
		$pdf->Output("Contrato.pdf",'I');
	}
	public function actionMenu()
	{
		return $this->render('menu');
	}
	public function actionEdit($id)
	{
		return null;
	}
	public function actionUpdate($id)
	{
		$req = Yii::$app->request;
    	$r = ['success'=>false];
		if (Yii::$app->user->identity->isAdmin()) {
	    	$con = Contract::findOne($id);
	    	$attrs = $req->post('Contract',[]);
	    	if($con && isset($attrs['salaries'])){
	    		if($con->salaries!=$attrs['salaries']){
		    		$con->salaries = $attrs['salaries'];
					if($con->save()){
						$r['success']=true;
					}else{
						// $aux = 
						// $r['message']=reset($con->getErrors())[0];
					}    			
	    		}else{
					$r['message']="No se ha hecho cambios";
	    		}
	    	}
		}
    	return json_encode($r);
	}
	public function actionCreate()
	{
		$modelName = $this->primaryModel;
        $request = ['success'=>false];
        $model = new $modelName;
        $model->load(Yii::$app->request->post());
        $model->idDepartment = $model->employee->idDepartment;
        $model->idJob = $model->employee->idJob;
        $model->minimumSalary = SettingsComponent::getSetting('minimumSalary');
        $model->salaries = $model->employee->salaries;
        if($model->endDate=="") $model->endDate='0000-00-00';
        if(Yii::$app->user->identity->hasCompany($model->employee->idCompany)){
	        if($model->save()){
	            $request['success']=true;
	        }else{
	        	$aux = $model->getErrors();
	            $request['message']=reset($aux)[0];
	        }
        }
        return json_encode($request);
	}
	public function actionNew()
	{
		$id = Yii::$app->request->get('id');
		$employee = Employee::findOne($id);
		$model = new Contract;
		$model->idEmployee = $employee->id;
		$model->entryDateCompany = $employee->entryDateCompany;
		$model->entryDateSaav = $employee->entryDateSaav;
		return $this->renderPartial('new',['model'=>$model]);
	}
	public function actionEmployeeListing($id)
	{
    	$models = Contract::find()->where(['idEmployee'=>$id]);//->addSelect(["*","(salaries*minimumSalary) AS fiscalSalary"]);
		$cols = ['idDepartment','idJob','idContractType','(salaries*minimumSalary*30.4166)','startDate','endDate','Contracts.id'];
		$models->joinWith(['department','contractType']);
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if($_GET['columns'][$index]['search']['value']) $models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		// echo $models->createCommand()->sql;
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['contracts/contract','id'=>$m->id])."' class='btn btn-xs btn-info' target='_blank' ><i class='fa fa-file'></i></a>";
			$lastContract = $m->employee->lastContract;

			if(Yii::$app->user->identity->isAdmin())
				// if($lastContract->id==$m->id) $actions[]="<a href='".Url::to(['contracts/edit-salary','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' ><i class='fa fa-money'></i></a>";
				$actions[]="<a href='".Url::to(['contracts/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			
			$startDate=$m->getDateField('startDate');
			$endDate=$m->getDateField('endDate');
			$r['data'][]=[
				$m->department->name,
				$m->job->name,
				$m->contractType->name,
				"$".number_format($m->fiscalMonthlySalary,2),
				$this->validDate($startDate)?$startDate->format('d/m/Y'):'--/--/----',
				$this->validDate($endDate)?$endDate->format('d/m/Y'):'--/--/----',
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);		
	}
	public function actionListing()
    {
    	$idCompanies = ArrayHelper::map(Yii::$app->user->identity->companies,'id','id');
    	$models = Contract::find()
    	->joinWith(['department','contractType','employee']);
		$cols = [
			'CONCAT(Employees.lastName1," ",Employees.lastName2,"",Employees.firstName)',
			'Employees.idDepartment',
			'Employees.idJob',
			'idContractType',
			'(Contracts.salaries*Contracts.minimumSalary*30.4166)',
			'startDate',
			'endDate',
			'Employees.idCompany'
		];
		$colsOrder = ['Employees.lastName1','idDepartment','idJob','idContractType','(Contracts.salaries*Contracts.minimumSalary*30.4166)','startDate','endDate','Employees.idCompany'];

		if(empty($_GET['columns'][7]['search']['value'])){
			$models->andWhere(['Employees.idCompany'=>$idCompanies]);
		}
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if(!empty($_GET['columns'][$index]['search']['value'])){
				$value = $_GET['columns'][$index]['search']['value'];
				$models->andWhere([is_numeric($value)?'=':'like',$c,$_GET['columns'][$index]['search']['value']]);
			}
		}
		$totalFiltered = $models->count();
		$models->orderBy($colsOrder[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		// echo $models->createCommand()->sql;
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['contracts/contract','id'=>$m->id])."' class='btn btn-xs btn-info' target='_blank' ><i class='fa fa-file'></i></a>";
			$lastContract = $m->employee->lastContract;
			
			if(Yii::$app->user->identity->isAdmin())
				// if($lastContract->id==$m->id) $actions[]="<a href='".Url::to(['contracts/edit-salary','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' ><i class='fa fa-money'></i></a>";
				$actions[]="<a href='".Url::to(['contracts/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";

			$startDate=$m->getDateField('startDate');
			$endDate=$m->getDateField('endDate');
			$r['data'][]=[
				$m->employee->fullNameInverse,
				$m->department->name,
				$m->job->name,
				$m->contractType->name,
				"$".number_format($m->fiscalMonthlySalary,2),
				$this->validDate($startDate)?$startDate->format('d/m/Y'):'--/--/----',
				$this->validDate($endDate)?$endDate->format('d/m/Y'):'--/--/----',
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
    public function actionTest()
    {
    	$contract = Contract::findOne(3);
    	$pdf = $this->generateContract($contract);
		$pdf->Output("Pedido.pdf",'I');   	
    }
    public function actionContract($id)
    {
    	$contract = Contract::findOne($id);
		$pdf = $this->getContractPdf($contract);
		$pdf->Output("Contrato.pdf",'I');
    }
    public function getContractPdf($contract)
    {
    	ob_start();
		$pdf = new \TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		$pdf->SetFont('dejavusans','',10);
		$pdf->SetMargins(15,15,15);
		// $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		// $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$vars = [
			'contract' => $contract,
			'companyName' => SettingsComponent::getSetting('companyName'),
			'companyAddress' => SettingsComponent::getSetting('companyAddress'),
			'employee' => $contract->employee,
			'employeeName' =>  strtoupper($contract->employee->fullName),
			'salaryWord' =>  \NumeroALetras::convertir(number_format($contract->fiscalMonthlySalary,2,'.',''),'pesos','centavos'),
			'testDays' =>  $contract->testDays,
		];
		$pdf->AddPage();
		$pdf->writeHTML($this->renderPartial('contracts/contract_'.$contract->contractType->viewName,$vars),true,false,true,false,'');
		$pdf->AddPage();
		$pdf->writeHTML($this->renderPartial('contracts/anex1',$vars),true,false,true,false,'');
		// $pdf->AddPage();
		// $pdf->writeHTML($this->renderPartial('contracts/welcome',$vars),true,false,true,false,'');
		$pdf->AddPage();
		$pdf->writeHTML($this->renderPartial('contracts/noticeOfPrivacy',$vars),true,false,true,false,'');
		$pdf->lastPage();
		ob_end_clean();
		return $pdf;
    }
}