<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use app\models\Company;
use app\models\User;
use app\models\Department;
use app\models\WorkingPeriod;

class CompaniesController extends Controller
{
    public $primaryModel = "\app\models\Company";
	public $newTitle = "Nueva empresa";
	public function actionCreate()
	{
		$modelName = $this->primaryModel;
        $r = ['success'=>false];
        $model = new $modelName;
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $editLink = Url::to(['companies/edit','id'=>$model->id]);
            $r['success']=true;
            $r['callbackScript']="
                closeCurrentModal(function(){
                    generateModal(null,'$editLink',1000);
                });
            ";
        }else{
            $aux = $model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
	}
	public function actionUpdate($id)
    {
        $r = ['success'=>false];
        $class = $this->primaryModel;
    	$model = $class::findOne($id);
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $r['success']=true;
        }else{
            $aux = $model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
    }
	public function actionEdit($id)
    {
        $class = $this->primaryModel;
        return $this->renderModal('edit',"Edición de empresa",['model'=>$class::findOne($id)]);
    }
    public function actionDelete($id)
    {
        $class = $this->primaryModel;
        $aux = $class::findOne($id);
        $aux->delete();
        return json_encode(['success'=>true,'callbackScript'=>'reloadAjaxTables();']);
    }
	public function actionListing()
    {
    	$models = Company::find()->joinWith('workingPeriod');
		$cols = ['Companies.name','WorkingPeriods.name','Companies.id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=$this->generateHtmlActions($m,900);
			$r['data'][]=[
				$m->name,
				$m->workingPeriod->name,
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
    public function actionPaydays()
    {
        $idPeriod = Yii::$app->request->post('id');
        $period = WorkingPeriod::findOne($idPeriod);
        return $this->renderPartial('paydaysOptions',['period'=>$period,'payDays'=>[]]);
    }
    public function actionUpdateDepartments($id)
    {
        $r = ['success'=>true];
        $company = Company::findOne($id);
        $departments = Yii::$app->request->post('departments');
        foreach ($company->departments as $d) {
            if(!in_array($d->id,$departments)) $company->unlink('departments',$d,true);
        }
        // agregamos nuevos permisos a departamentos
        foreach ($departments as $dId) {
            $dep = Department::findOne($dId);
            if($dep && !$company->hasDepartment($dId)) $company->link('departments',$dep);
        }
        return json_encode($r);
    }
}