<?php 
namespace app\components\reports;
use app\components\reports\MainReportComponent;
use app\models\Employee;
use app\models\Incident;
use app\models\Company;
use app\models\Contract;
class ExpirationsContracts extends MainReportComponent{
	public static function get($companies,$startDate,$endDate)
    {
        $r = new \PHPExcel;
        $r->getProperties()->setTitle("Contratos vencidos");
        $r->setActiveSheetIndex(0)->setTitle("Contratos");
        $s = $r->getActiveSheet();
        // estilo
        $s->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $s->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $s->getDefaultStyle()->getFont()->setSize(8);
        $s->getDefaultStyle()->getFont()->setName("Century Gothic");

        $s->getDefaultRowDimension()->setRowHeight(18);
        $s->getDefaultColumnDimension()->setWidth(15);
        // Titulos
        // $s->setCellValue('A2','Empresa:');
        // $s->setCellValue('B2',"SAAV CANCUN S.A de C.V");
        // $s->setCellValue('A3','Cliente:');
        // $s->setCellValue('B3',$company->name);
        // $s->freezePane('C8');
        // $s->getColumnDimension('B')->setWidth(45);
        // $s->getColumnDimension('C')->setWidth(35);
        // $s->getColumnDimension('D')->setWidth(30);
        // Header
        $cols = self::getCols();
        $col = 0;
        $header1 = [
            "ID Empleado",
            "Nombre Empleado",
            "Empresa",
            "Departamento",
            "Puesto",
            "Tipo de contrato",
            "Salario Mensual",
            "Inicia",
            "Vence",
            "Días de prueba",
            "Días de prueba (acumulado)",
        ];
        foreach ($header1 as $h) {
            $cell = $cols[$col].'1';
            $s->setCellValue($cell,$h);
            $col++;
        }
        $s->getStyle("A1:{$cols[$col-1]}1")->getAlignment()->setWrapText(true);
        $s->getStyle("A1:{$cols[$col-1]}1")->applyFromArray(self::getStyle());
        $s->getRowDimension(1)->setRowHeight(30);

        $row = 2;
        $contracts = self::getContracts($companies,$startDate,$endDate);
        foreach ($contracts as $cont) {
            $startDate = $cont->getDateField('startDate');
            $endDate = $cont->getDateField('endDate');
            $values = [
                $cont->employee->refId,
                $cont->employee->fullName,
                $cont->employee->company->name,
                $cont->department->name,
                $cont->job->name,
                $cont->contractType->name,
                $cont->fiscalMonthlySalary,
                self::validDate($startDate)?$startDate->format('d/m/Y'):'--/--/----',
                self::validDate($endDate)?$endDate->format('d/m/Y'):'--/--/----',
                $cont->testDays,
                $cont->employee->getContracts()->andWhere("id < {$cont->id}")->sum('testDays')+$cont->testDays,
            ];
            $col = 0;
            foreach ($values as $v){
                $cell = $cols[$col].$row;
                $s->setCellValue($cell,$v);
                if($cols[$col]=='G') $s->getStyle($cell)->getNumberFormat()->setFormatCode('[$$-80A]#,##0.00;-[$$-80A]#,##0.00');
                $col++;
            }
            $row++;
        }
        // $s->getStyle("A6:{$cols[$col-1]}7")->getAlignment()->setWrapText(true);
        // $s->getStyle("A6:{$cols[$col-1]}7")->applyFromArray(self::getStyle());
        // $s->getRowDimension(6)->setRowHeight(30);
        // $s->getRowDimension(7)->setRowHeight(30);
        // self::setContracts($s,$company);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="ContratosVencidos.xls"');
        header('Cache-Control: max-age=0');
        $objWriter = \PHPExcel_IOFactory::createWriter($r,'Excel5');
        $objWriter->setPreCalculateFormulas(false);
        $objWriter->save('php://output');
    }
    public static function getContracts($companies,$startDate,$endDate)
    {
        $q = Employee::find()->where(['idCompany'=>$companies])
        ->joinWith(['company'])
        ->orderBy("Companies.name ASC, refId ASC");
        $contracts = [];
        foreach ($q->all() as $em) {
            $aux = $em->getContracts()
            ->where("endDate != '0000-00-00' AND endDate >= '$startDate' AND endDate <= '$endDate'")
            ->orderBy('endDate DESC')
            ->one();
            if($aux) $contracts[]=$aux;
        }
        return $contracts;
    }
}