<?php 
namespace app\components\reports;
use app\components\reports\MainReportComponent;
use app\models\Employee;
use app\models\Incident;
use app\models\Company;
use app\models\Contract;
class Employees extends MainReportComponent{
	public static function get($companies,$departments,$jobs,$status)
	{
        $r = new \PHPExcel;
        $r->getProperties()->setTitle("Empleados");
        $r->setActiveSheetIndex(0)->setTitle("Empleados");
        $s = $r->getActiveSheet();
        // estilo
        $s->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $s->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $s->getDefaultStyle()->getFont()->setSize(8);
        $s->getDefaultStyle()->getFont()->setName("Century Gothic");

        $s->getDefaultRowDimension()->setRowHeight(18);
        $s->getDefaultColumnDimension()->setWidth(15);
        // Header
        $cols = self::getCols();
        $col = 0;
        $header1 = [
            "ID Empleado",
            "Nombre Empleado",
            "Empresa",
            "Departamento",
            "Puesto",
            "Numero IMSS",
            "RFC",
            "CURP",
            "Estatus",
            "Fecha Estatus",
            "Tipo contrato",
            "Salario diario",
            "Sueldo mes",
        ];
        foreach ($header1 as $h) {
            $cell = $cols[$col].'1';
            $s->setCellValue($cell,$h);
            $col++;
        }
        $s->getStyle("A1:{$cols[$col-1]}1")->getAlignment()->setWrapText(true);
        $s->getStyle("A1:{$cols[$col-1]}1")->applyFromArray(self::getStyle());
        $s->getRowDimension(1)->setRowHeight(30);

        $row = 2;
        $employees = self::getEmployees($companies,$departments,$jobs,$status);
        foreach ($employees as $e) {
        	$dateAttrByStatus = [Employee::STATUS_ACTIVE=>'creationDate',Employee::STATUS_INACTIVE=>'inactiveDate',Employee::STATUS_READMISSION=>'readmissionDate'];
        	$lastContract = $e->lastContract;
            $values = [
            	$e->refId,
            	$e->fullNameInverse,
            	$e->company->name,
            	$e->department->name,
            	$e->job->name,
            	$e->nss,
            	$e->rfc,
            	$e->curp,
            	Employee::getStatusOptions()[$e->status],
            	$e->lastChange->getDateField('applyDate','d/m/Y'),
            	$lastContract?$lastContract->contractType->name:"S/C",
            	$lastContract?$lastContract->fiscalSalary:'S/C',
            	$lastContract?$lastContract->fiscalMonthlySalary:'S/C',
            ];
            $col = 0;
            foreach ($values as $v){
                $cell = $cols[$col].$row;
                $s->setCellValue($cell,$v);
                if(($cols[$col]=='L' || $cols[$col]=='M') && is_numeric($v)) $s->getStyle($cell)->getNumberFormat()->setFormatCode('[$$-80A]#,##0.00;-[$$-80A]#,##0.00');
                $col++;
            }
            $row++;
        }
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Empleados.xls"');
        header('Cache-Control: max-age=0');
        $objWriter = \PHPExcel_IOFactory::createWriter($r,'Excel5');
        $objWriter->setPreCalculateFormulas(false);
        $objWriter->save('php://output');
	}
	public static function getEmployees($companies,$departments,$jobs,$status)
	{
		return Employee::find()
		->joinWith(['department','job','company'])
		->where(['idCompany'=>$companies,'idDepartment'=>$departments,'idJob'=>$jobs,'status'=>$status])
		->orderBy("Companies.name ASC, refId ASC")
		->all();
	}
}