<?php 
namespace app\components;
use Yii;
use yii\base\Component;
use app\models\Employee;
use app\models\Incident;
use app\models\IncidentCategory;
use app\models\VacationRequest;
use app\models\PermissionRequest;
use app\models\User;
use app\models\NoticeRequest;
use app\models\SettlementRequest;
use app\components\IncidentCategoriesComponent;
class RequestsComponent extends Component{
	public static function setVacations($req)
	{
		$idVacationIncidentCat = IncidentCategoriesComponent::get('V');
		$idBreakIncidentCat = IncidentCategoriesComponent::get('D');
		$idHolidayIncidentCat = IncidentCategoriesComponent::get('DF');
		$auxStart = $req->startDate;
		list($realBreakDays,$breaks,$holidays,$permissions,$vacations) = EmployeesComponent::getEmployeeBreaksByDays($req->employee,$req->startDate,$req->daysToUse);
		$breackBackup = $req->requiredBreakDays;
		$breaks = array_merge($breackBackup,$breaks);//para las papeletas anteriores
		while ($auxStart<=$req->endDate) {
			$idCat = $idVacationIncidentCat;
			if(!in_array($auxStart, $permissions) && !in_array($auxStart, $vacations)){
				if(in_array($auxStart, $breaks)) $idCat = $idBreakIncidentCat;
				else if(in_array($auxStart, $holidays)) $idCat = $idHolidayIncidentCat;

				// busca la incidencia para actualizar o crear una nueva
				$inc = Incident::findOne(['idEmployee'=>$req->idEmployee,'date'=>$auxStart]);
				if($inc){
					// si el día esta diferente a lo que dice el request, actualiza
					if($inc->idIncidentCategory!=$idCat || $inc->idRequest!=$req->id){
						$inc->idIncidentCategory = $idCat;
						$inc->idRequest = $req->id;
						$inc->requestType = Incident::REQUEST_TYPE_VACATION;
						$inc->save();			
					}
				}else{
					$inc = new Incident;
					$inc->idEmployee = $req->idEmployee;
					$inc->date = $auxStart;
					$inc->idIncidentCategory = $idCat;
					$inc->idRequest = $req->id;
					$inc->requestType = Incident::REQUEST_TYPE_VACATION;
					$inc->save();
				}				
			}
			$auxStart = date('Y-m-d',strtotime($auxStart.' +1 day'));
		}			
	}
	public static function setPermission($req)
	{
		$idPermissionIncidentCat = $req->idIncidentCategory;
		$idBreakIncidentCat = IncidentCategoriesComponent::get('D');
		$idHolidayIncidentCat = IncidentCategoriesComponent::get('DF');
		$auxStart = $req->startDate;
		list($realBreakDays,$breaks,$holidays,$permissions,$vacations) = EmployeesComponent::getEmployeeBreaksByDays($req->employee,$req->startDate,$req->daysToUse);
		$breackBackup = $req->requiredBreakDays;
		$breaks = array_merge($breackBackup,$breaks);//para las papeletas anteriores
		while ($auxStart<=$req->endDate) {
			$idCat = $idPermissionIncidentCat;
			if(!in_array($auxStart, $permissions) && !in_array($auxStart, $vacations)){
				if(in_array($auxStart, $breaks)) $idCat = $idBreakIncidentCat;
				else if(in_array($auxStart, $holidays)) $idCat = $idHolidayIncidentCat;
				// busca la incidencia para actualizar o crear una nueva
				$inc = Incident::findOne(['idEmployee'=>$req->idEmployee,'date'=>$auxStart]);
				if($inc){
					// si el dia esta diferente a lo que dice el request, actualiza
					if($inc->idIncidentCategory!=$idCat || $inc->idRequest!=$req->id){
						$inc->idIncidentCategory = $idCat;
						$inc->idRequest = $req->id;
						$inc->requestType = Incident::REQUEST_TYPE_PERMISSION;
						$inc->save();			
					}
				}else{
					$inc = new Incident;
					$inc->idEmployee = $req->idEmployee;
					$inc->date = $auxStart;
					$inc->idIncidentCategory = $idCat;
					$inc->idRequest = $req->id;
					$inc->requestType = Incident::REQUEST_TYPE_PERMISSION;
					$inc->save();
				}						
			}
			$auxStart = date('Y-m-d',strtotime($auxStart.' +1 day'));
		}			
	}
	public static function setNotice($req)
	{
		if($req->noticeType!=NoticeRequest::TYPE_HE){
			$inc = Incident::find()
			->where(['idEmployee'=>$req->idEmployee,'date'=>$req->eventDate])
			->one();
			// busca la incidencia para actualizar o crear una nueva
			if($inc){
				// si la categoria esta diferente a lo que dice el request, actualiza
				if($inc->idIncidentCategory!=$req->idIncidentCategory || $inc->idRequest!=$req->id){
					$inc->idIncidentCategory = $req->idIncidentCategory;
					$inc->idRequest = $req->id;
					$inc->requestType = Incident::REQUEST_TYPE_NOTICE;
					$inc->save();						
				}
			}else{
				$inc = new Incident;
				$inc->idEmployee = $req->idEmployee;
				$inc->date = $req->eventDate;
				$inc->idIncidentCategory = $req->idIncidentCategory;
				$inc->idRequest = $req->id;
				$inc->requestType = Incident::REQUEST_TYPE_NOTICE;
				$inc->save();
			}			
		}
	}
	public static function getNoticeRequestsExtraHours($idEmployee,$startDate,$endDate)
	{
		$aux = NoticeRequest::find()
		->where(['idEmployee'=>$idEmployee])
		->andWhere("eventDate >= '$startDate' AND eventDate <= '$endDate'")
		->andWhere(['noticeType'=>NoticeRequest::TYPE_HE])
		->sum('extraHours');
		return $aux?$aux:0;
	}
	public static function getRequestPdf($request,$type)
	{
		ob_start();
        $pdf = new \TCPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        $pdf->SetFont('dejavusans','',8);
        $pdf->SetMargins(8,8,8);
        // $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        // $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->AddPage();
        $pdf->writeHTML(Yii::$app->controller->renderPartial('//requests/pdfs/'.$type,['req'=>$request]),true,false,true,false,'');
        $pdf->lastPage();
        ob_end_clean();
        return $pdf;
	}
	public static function sendSettlementNotification($settlement)
	{
		$settlement->refresh();
		$pdf = self::getRequestPdf($settlement,'settlement');

		// usuarios con permiso a la empresa
    	$users = User::find()
    	->joinWith('companies')
    	->where(["Companies.id"=>$settlement->employee->idCompany,'role'=>[User::ROLE_MANAGER,User::ROLE_EXECUTIVE]])
    	->all();

    	$emails=[];
        foreach ($users as $u) $emails[] = $u->email;
        if(!in_array(Yii::$app->user->identity->email, $emails)) $emails[]=Yii::$app->user->identity->email; 

		 Yii::$app->mailer->compose()
        ->setFrom('sistema@lamhi.com.mx')
        // ->setTo(['uicab2593@gmail.com'])
        ->setTo($emails)
        ->setSubject('Notificación de finiquito')
        ->setHtmlBody(Yii::$app->controller->renderPartial('//requests/settlementNotification'))
        ->attachContent($pdf->Output('finiquito.pdf','S'),['fileName'=>'finiquito.pdf','contentType'=>'application/pdf'])
        ->send();
	}
}