<?php 
namespace app\components;
use yii\base\Component;
use app\models\Employee;
use app\models\Contract;
use app\models\Period;
use app\models\PayrollConcept;
use app\components\PeriodsComponent;
class PayrollConceptsComponent extends Component{
    public static $perceptions = [
        'horasExtraP'=>'Horas Extra',
        'comisionesP'=>'Comisiones',
        'anticiposP'=>'Anticipos',
        'bonosP'=>'Bonos',
        'compensacionesP'=>'Compensaciones',
        'otrosP'=>'Otras percepciones',
    ];
    public static $deductions = [
        'prestamosD'=>'Prestamos',
        'anticiposD'=>'Anticipos',
        'cxcD'=>'CXC',
        'otrosD'=>'Otras deducciones',
    ];
    public static $concepts = [
        'horasExtraP'=>'Horas Extra',
        'comisionesP'=>'Comisiones',
        'anticiposP'=>'Anticipos',
        'bonosP'=>'Bonos',
        'compensacionesP'=>'Compensaciones',
        'otrosP'=>'Otras percepciones',
        'prestamosD'=>'Prestamos',
        'anticiposD'=>'Anticipos',
        'cxcD'=>'CXC',
        'otrosD'=>'Otras deducciones',
    ];
    public static function getEmployeeConcepts($idEmployee,$idPeriod)
    {
        $pc = PayrollConcept::findOne(['idEmployee'=>$idEmployee,'idPeriod'=>$idPeriod]);
        $period = Period::findOne($idPeriod);
        if($pc==null){
            $pc = new PayrollConcept;
            $pc->idEmployee = $idEmployee;
            $pc->idPeriod = $idPeriod;
            $pc->horasExtraP = RequestsComponent::getNoticeRequestsExtraHours($idEmployee,$period->startDate,$period->endDate);
        }else{
            $pc->horasExtraP = RequestsComponent::getNoticeRequestsExtraHours($idEmployee,$period->startDate,$period->endDate);
        }
        return $pc;
    }
    public static function getDepartmentsUncharged($period)
    {
        // busca los departamentos que no se han cargado incidencias del periodo que se pide
        $departmentsFail = [];
        foreach ($period->company->departments as $dep) {
            // obten un empleado de cada departamento
            $emp = PeriodsComponent::getActiveEmployeesQuery($period,[$dep->id])->one();
            if($emp){
                $inc = PayrollConcept::findOne(['idEmployee'=>$emp->id,'idPeriod'=>$period->id]);
                if($inc==null) $departmentsFail[]=$dep;
            }
        }
        return $departmentsFail;
    }
}