<?php 
namespace app\components;
use yii\base\Component;
use app\models\Incident;
use app\models\Employee;
use app\models\Period;
use app\components\PeriodsComponent;
use app\components\IncidentCategoriesComponent;
use app\components\RequestsComponent;
use app\components\HolidaysComponent;
use app\models\IncidentCategory;
class IncidentsComponent extends Component{
	public static function getEmployeeIncidents($idEmployee,$period)
	{
		$assistanceCat = IncidentCategoriesComponent::get('-');
		$auxStart = $period->startDate;
		// arreglo de incidencias donde la llave es la fecha de la incidencia y la incidencia es el objeto
		$incidentsArray = [];
		while ($auxStart<=$period->endDate) {
				$aux = new Incident;
				$aux->idEmployee = $idEmployee;
				$aux->date = $auxStart;
				$aux->idIncidentCategory = $assistanceCat;

			$incidentsArray[$auxStart] = $aux;
			$auxStart = date('Y-m-d',strtotime($auxStart.' +1 day'));
		}
		$incidents = Incident::find()
		->where(['idEmployee'=>$idEmployee])
		->andWhere("date >= '{$period->startDate}' AND date <= '{$period->endDate}'")
		->all();
		foreach ($incidents as $i) $incidentsArray[$i->date] = $i;
		// aplicando festivos
		self::applyHolidays($incidentsArray,$idEmployee,$period);
		// aplicando días de descanso si el periodo esta abierto.
		if($period->status==Period::STATUS_OPEN) self::checkBreakDays($incidentsArray,$idEmployee);
		return $incidentsArray;
	}
	public static function getDepartmentsUncharged($period)
	{
		// busca los departamentos que no se han cargado incidencias del periodo que se pide
		$departmentsFail = [];
		foreach ($period->company->departments as $dep) {
			// obtén un empleado de cada departamento
			$emp = PeriodsComponent::getActiveEmployeesQuery($period,[$dep->id])->one();
			if($emp){
				$inc = Incident::find()
				->where(['idEmployee'=>$emp->id])
				->andWhere("date >= '{$period->startDate}' AND date <= '{$period->endDate}'")
				->one();
				if($inc==null) $departmentsFail[]=$dep;
			}
		}
		return $departmentsFail;
	}
	public static function applyHolidays(&$incidentsArray,$idEmployee,$period)
	{
		$holidays = HolidaysComponent::getDays($period->startDate,$period->endDate);
		$assistance = IncidentCategoriesComponent::get('-');//IncidentCategory::findOne(['tag'=>'-'])->id;
		$holidayCat = IncidentCategoriesComponent::get('DF');
		foreach ($holidays as $h => $hDesc) {
			$inc = $incidentsArray[$h];
			if($inc->isNewRecord || !in_array($inc->idIncidentCategory, IncidentCategoriesComponent::getHolidayOptions())){
				$inc->idIncidentCategory = $holidayCat;
				if(!$inc->isNewRecord) $inc->save();
			}
		}
	}
	public static function checkBreakDays(&$incidentsArray,$idEmployee)
	{
		$idBreakCat = IncidentCategoriesComponent::get('D');
		$idAsisCat = IncidentCategoriesComponent::get('-');
		$emp = Employee::findOne($idEmployee);
		$breaks = str_split($emp->breakDays);
		foreach ($incidentsArray as $date => $inc) {
			if(in_array(date('w',strtotime($date)), $breaks)){
				if($inc->isNewRecord){
					$inc->idIncidentCategory = $idBreakCat;
					// if(!$inc->isNewRecord) $inc->save();
				}
			}
			// else if($inc->idIncidentCategory==$idBreakCat){
				// $inc->idIncidentCategory = $idAsisCat;
				// if(!$inc->isNewRecord) $inc->save();
			// }
		}
	}
}