<?php 
namespace app\components;
use \Yii;
use yii\base\Component;
use app\components\IncidentCategoriesComponent;
use app\models\Employee;
use app\models\Incident;
use app\models\EmployeeChange;
use app\models\Contract;
class EmployeesComponent extends Component{
    public static $orderQuery = "CASE WHEN (refId*1)=0 THEN 999999 ELSE (refId*1) END ASC";
	public static function getEmployeesByDepartment($depId)
    {
        $contracts = Contract::find()
        ->joinWith('employee')
        ->where(['idDepartment'=>$depId])
        ->orderBy("id DESC")
        ->all();
        $employees = [];
        foreach ($contracts as $c) {
            if($c->employee->lastContract->id==$c->id) $employees[]=$c->employee;
        }
        return $employees;
    }
    public static function saveChangeStatus($employee,$applyDate)
    {
        $employee->refresh();
        $newChange = new EmployeeChange;
        $newChange->idEmployee = $employee->id;
        $newChange->salaries = $employee->salaries;
        $newChange->status = $employee->status;
        $newChange->minimumSalary = $employee->minimumSalary;
        $newChange->entryDateCompany = $employee->entryDateCompany;
        $newChange->entryDateSaav = $employee->entryDateSaav;
        $newChange->changeType = $employee->status;
        $newChange->applyDate = $applyDate;
        $newChange->idCreationUser = Yii::$app->user->identity->id;
        $newChange->creationDate = date('Y-m-d H:i:s');
        $newChange->save(); 
        self::sendChangeNotice($newChange);
    }
    public static function saveChangeSalary($employee,$applyDate)
    {
        $employee->refresh();
        $newChange = new EmployeeChange;
        $newChange->idEmployee = $employee->id;
        $newChange->salaries = $employee->salaries;
        $newChange->status = $employee->status;
        $newChange->minimumSalary = $employee->minimumSalary;
        $newChange->entryDateCompany = $employee->entryDateCompany;
        $newChange->entryDateSaav = $employee->entryDateSaav;
        $newChange->changeType = EmployeeChange::CHANGE_TYPE_SALARY;
        $newChange->applyDate = $applyDate;
        $newChange->idCreationUser = Yii::$app->user->identity->id;
        $newChange->creationDate = date('Y-m-d H:i:s');
        $newChange->save(); 
        self::sendChangeNotice($newChange);
    }
    public static function sendChangeNotice($employeeChange)
    {
        $employeeChange->refresh();
        $pdf = self::getEmployeeChangePdf($employeeChange);
        Yii::$app->mailer->compose()
        ->setFrom('sistema@lamhi.com.mx')
        ->setTo('info@lamhi.com.mx')
        // ->setTo('uicab2593@gmail.com')
        ->setSubject('Notificación de movimiento en empleado')
        ->attachContent($pdf->Output($employeeChange->fileName.'.pdf','S'),['fileName'=>$employeeChange->fileName.'.pdf','contentType'=>'application/pdf'])
        ->send();
    }
    public static function getEmployeeChangePdf($employeeChange)
    {
        ob_start();
        $pdf = new \TCPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        $pdf->SetFont('dejavusans','',8);
        $pdf->SetMargins(8,8,8);
        // $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        // $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->AddPage();
        $pdf->writeHTML(Yii::$app->controller->renderPartial('//employees/change-pdf',['change'=>$employeeChange]),true,false,true,false,'');
        $pdf->lastPage();
        ob_end_clean();
        return $pdf;
    }
    public static function getNextId()
    {
        return Employee::find()
        ->select('refId')
        ->orderBy('(refId * 1) DESC')
        ->scalar() +1;
    }
    public static function getBreakDaysArray($emp,$startDate,$endDate)
    {
        $breakDays = str_split($emp->breakDays);
        $auxStartDate = $startDate;
        $breaks = [];
        while ($auxStartDate<=$endDate) {
            if(in_array(date('w',strtotime($auxStartDate)), $breakDays)){
                $breaks[]=$auxStartDate;
            }
            $auxStartDate = date('Y-m-d',strtotime($auxStartDate.' +1 day'));
        }
        return $breaks;
    }
    public static function getEmployeeBreaksByDays($emp,$startDate,$days)
    {
        $auxStartDate = new \DateTime($startDate);
        $holidays = HolidaysComponent::getDays($startDate);
        $breakDays = str_split($emp->breakDays);
        $realBreakDays = 0;
        $employeeBreaks = [];
        $employeeHolidays = [];
        $employeePermissions = [];
        $employeeVacations = [];
        $breaksCat = IncidentCategoriesComponent::get('D');
        $permissionsCat = [IncidentCategoriesComponent::get('PCG'),IncidentCategoriesComponent::get('PSG'),];
        $vacationCat = IncidentCategoriesComponent::get('V');
        $formatedDate = $auxStartDate->format('Y-m-d');
        $findedWorkDate = false;
        while($realBreakDays<$days || !$findedWorkDate){
            $formatedDate = $auxStartDate->format('Y-m-d');
            // busca la incidencia de este día para saber que tiene seleccionado
            $inc = Incident::findOne(['idEmployee'=>$emp->id,'date'=>$formatedDate]);
            if(($inc && $inc->idIncidentCategory==$breaksCat) || ($inc==null && in_array($auxStartDate->format('w'), $breakDays))){
                $employeeBreaks[]=$formatedDate;
            }else if(isset($holidays[$formatedDate])){
                $employeeHolidays[]=$formatedDate;
            }else if($realBreakDays<$days){
                $realBreakDays++;
            }else if($inc && in_array($inc->idIncidentCategory, $permissionsCat)){
                $employeePermissions[] = $formatedDate;
            }else if($inc && $inc->idIncidentCategory==$vacationCat){
                $employeeVacations[] = $formatedDate;
            }else{
                $findedWorkDate = true;
            }
            $auxStartDate->modify('+1 day');
        }
        // el día después del endDate debe ser el dia de entrada pero puede ser que tenga permiso o descanso
        // $formatedDate = $auxStartDate->format('Y-m-d');
        // $inc = Incident::findOne(['idEmployee'=>$emp->id,'date'=>$formatedDate]);
        // $finded = false;
        // while (!$finded) {
        //     $auxStartDate->modify('+1 day');
        // }
        return [$realBreakDays,$employeeBreaks,$employeeHolidays,$employeePermissions,$employeeVacations];
    }
}