<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'css/main.css?v=3',
    ];
    public $js = [
        'js/bootstrap.min.js',
        'js/plugins/alertifyjs/alertify.min.js',
        'js/plugins/validate/jquery.validate.min.js',
        'js/plugins/form/jquery.form.min.js',
        'js/plugins/datatables/jquery.dataTables.js?v=1',
        'js/plugins/datatables/datatables-bs3.js',
        'js/plugins/bootstrap-manager/bootstrap-modal.js',
        'js/plugins/bootstrap-manager/bootstrap-modalmanager.js',
        'js/plugins/jquery.number.min.js',
        'js/jquery-ui.min.js',
        'js/trumbowyg.js',
        'js/bootstrap-multiselect.js',
        'js/plugins/trumbowyg.base64.js',
        'js/cloudapps.js?v=15',
        'js/main.js?v=15',
    ];
    public $depends = [
        'yii\web\YiiAsset',
        // 'yii\bootstrap\BootstrapAsset',
    ];
}
